/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.pvalsecc.comm.ObjectClientConnection;

public class ObjectStreamClientConnection<OUT>
extends ObjectClientConnection<OUT> {
    public ObjectStreamClientConnection(InetSocketAddress address) throws IOException {
        super(address);
    }

    public void getData(OUT request, Stream answer) throws Exception {
        this.sendRequest(request);
        this.receiveReply(answer);
    }

    private void receiveReply(Stream answer) throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(61440);
        ByteBuffer previousReadBuffer = ByteBuffer.allocate(61440);
        while (true) {
            int nb;
            if ((nb = this.socket.read(readBuffer)) <= 0) {
                throw new IOException("Message not fully received");
            }
            readBuffer.flip();
            int len = 0;
            while (readBuffer.remaining() >= 4) {
                len = readBuffer.getInt();
                if (len == 0) {
                    if (readBuffer.remaining() != 0) {
                        throw new RuntimeException("Receving data after the END marker");
                    }
                    return;
                }
                if (readBuffer.remaining() < len) break;
                byte[] result = new byte[len];
                readBuffer.get(result);
                answer.onObjectReceived(result);
                len = 0;
            }
            previousReadBuffer.rewind();
            if (len + 4 > previousReadBuffer.remaining()) {
                previousReadBuffer = ByteBuffer.allocate(len + 4);
            }
            if (len > 0) {
                previousReadBuffer.putInt(len);
            }
            previousReadBuffer.put(readBuffer);
            ByteBuffer temp = previousReadBuffer;
            previousReadBuffer = readBuffer;
            readBuffer = temp;
        }
    }

    public static interface Stream {
        public void onObjectReceived(byte[] var1) throws Exception;
    }
}

