/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.graph.dijkstra;

import java.util.ArrayList;
import java.util.List;
import org.pvalsecc.graph.dijkstra.Edge;

class Vertex<EDGE extends Edge>
implements Comparable<Vertex<EDGE>> {
    private long id;
    private double cost;
    private EDGE previousEdge;
    private List<EDGE> edges = new ArrayList<EDGE>(1);

    public Vertex(long id) {
        this.id = id;
        this.cost = Double.MAX_VALUE;
        this.previousEdge = null;
    }

    public List<EDGE> getEdges() {
        return this.edges;
    }

    public long getId() {
        return this.id;
    }

    public double getCost() {
        return this.cost;
    }

    public EDGE getPreviousEdge() {
        return this.previousEdge;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    @Override
    public int compareTo(Vertex<EDGE> other) {
        int result = Double.compare(this.cost, other.getCost());
        if (result == 0) {
            long id2 = other.getId();
            result = this.id < id2 ? -1 : (this.id == id2 ? 0 : 1);
        }
        return result;
    }

    public void setPreviousEdge(EDGE previousEdge) {
        this.previousEdge = previousEdge;
    }

    public String toString() {
        return "Vertex{id=" + this.id + " cost=" + this.cost + "}";
    }

    public void add(EDGE edge) {
        this.edges.add(edge);
    }
}

