/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.jdbc;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pvalsecc.jdbc.Column;
import org.pvalsecc.jdbc.Entity;
import org.pvalsecc.jdbc.Id;

public class BeanDbMapper<CLASS> {
    private static Log log = LogFactory.getLog(BeanDbMapper.class);
    private List<ColumnMapping<CLASS>> cols = new ArrayList<ColumnMapping<CLASS>>();
    private Constructor<CLASS> constructor;
    private Class<CLASS> aClass;
    private Entity table;

    public BeanDbMapper(Class<CLASS> aClass) {
        this.aClass = aClass;
        this.table = aClass.getAnnotation(Entity.class);
        if (this.table == null) {
            throw new RuntimeException("Cannot find @Table for class " + aClass.getSimpleName());
        }
        try {
            this.constructor = aClass.getConstructor(new Class[0]);
            for (int i = 0; i < aClass.getDeclaredFields().length; ++i) {
                Field field = aClass.getDeclaredFields()[i];
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                this.cols.add(new ColumnMapping<CLASS>(field, column, aClass));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem with the structure of class " + aClass.getSimpleName(), e);
        }
    }

    public String getTableName() {
        return this.table.name();
    }

    public String getFieldNames() {
        return this.getFieldNames(null);
    }

    public String getFieldNames(String prefix) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.cols.size(); ++i) {
            ColumnMapping<CLASS> columnMapping = this.cols.get(i);
            if (result.length() > 0) {
                result.append(',');
            }
            if (prefix != null) {
                result.append(prefix);
            }
            result.append(columnMapping.getDBName());
        }
        return result.toString();
    }

    public String getPrimaryKeyFieldName() {
        for (int i = 0; i < this.cols.size(); ++i) {
            ColumnMapping<CLASS> columnMapping = this.cols.get(i);
            if (!((ColumnMapping)columnMapping).primaryKey) continue;
            return columnMapping.getDBName();
        }
        throw new RuntimeException("Did not find any primary key for class " + this.aClass.getSimpleName());
    }

    public PropertyDescriptor getField(String dbName) {
        for (int i = 0; i < this.cols.size(); ++i) {
            ColumnMapping<CLASS> columnMapping = this.cols.get(i);
            if (!columnMapping.getDBName().equals(dbName)) continue;
            return ((ColumnMapping)columnMapping).property;
        }
        throw new RuntimeException("Did not find any field named " + dbName);
    }

    public CLASS createFromDb(ResultSet rs, int pos) throws SQLException {
        CLASS bean;
        try {
            bean = this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot invoque constructor for class " + this.aClass.getSimpleName(), e);
        }
        for (int i = 0; i < this.cols.size(); ++i) {
            ColumnMapping<CLASS> columnMapping = this.cols.get(i);
            columnMapping.getFromDb(bean, rs, pos++);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLASS> selectFromDb(Connection conn) throws SQLException {
        StringBuffer query = new StringBuffer("select ");
        query.append(this.getFieldNames(null));
        query.append(" from ").append(this.getTableName());
        if (log.isDebugEnabled()) {
            log.debug("query for farmers is: " + query.toString());
        }
        Statement stmt = conn.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(query.toString());
            ArrayList<CLASS> result = new ArrayList<CLASS>();
            while (rs.next()) {
                result.add(this.createFromDb(rs, 1));
            }
            ArrayList<CLASS> arrayList = result;
            return arrayList;
        }
        finally {
            stmt.close();
        }
    }

    public int saveToDb(PreparedStatement stmt, CLASS bean, int pos) {
        for (int i = 0; i < this.cols.size(); ++i) {
            ColumnMapping<CLASS> columnMapping = this.cols.get(i);
            columnMapping.setToDb(bean, stmt, pos++);
        }
        return pos;
    }

    public String getInsertPlaceHolders() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.cols.size(); ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append('?');
        }
        return result.toString();
    }

    private static class ColumnMapping<CLASS> {
        private boolean primaryKey = false;
        private PropertyDescriptor property;
        private String dbName;

        public ColumnMapping(Field field, Column column, Class<CLASS> aClass) throws IntrospectionException {
            if (field.getAnnotation(Id.class) != null) {
                this.primaryKey = true;
            }
            this.dbName = ColumnMapping.extractDbName(field, column);
            this.property = new PropertyDescriptor(field.getName(), aClass);
        }

        private static String extractDbName(Field field, Column column) {
            if (column.name().length() > 0) {
                return column.name();
            }
            StringBuffer parsedPrefix = new StringBuffer();
            String propertyName = field.getName();
            for (int i = 0; i < propertyName.length(); ++i) {
                char c = propertyName.charAt(i);
                if (Character.isUpperCase(c)) {
                    parsedPrefix.append("_");
                    parsedPrefix.append(c);
                    continue;
                }
                parsedPrefix.append(c);
            }
            return parsedPrefix.toString().toLowerCase();
        }

        public String getDBName() {
            return this.dbName;
        }

        public void getFromDb(CLASS bean, ResultSet rs, int pos) throws SQLException {
            Object value = rs.getObject(pos);
            if (rs.wasNull()) {
                value = null;
            }
            try {
                this.property.getWriteMethod().invoke(bean, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke method " + this.property.getWriteMethod() + " in class " + bean.getClass().getSimpleName() + " with value=" + value + "(" + (value != null ? value.getClass().getSimpleName() : "") + ")", e);
            }
        }

        public Object getValue(CLASS bean) {
            try {
                return this.property.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke method " + this.property.getReadMethod() + " in class " + bean.getClass().getSimpleName(), e);
            }
        }

        public void setToDb(CLASS bean, PreparedStatement stmt, int pos) {
            try {
                stmt.setObject(pos, this.property.getReadMethod().invoke(bean, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke method " + this.property.getReadMethod() + " in class " + bean.getClass().getSimpleName(), e);
            }
        }
    }
}

