/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pvalsecc.misc.StringUtils;

public abstract class ConnectionFactory {
    private static final Pattern GET_SUBPROTOCOL = Pattern.compile("^jdbc:([^:]+):.*$", 2);
    private static final Map<String, List<String>> DRIVERS = new HashMap<String, List<String>>();

    public static Connection getConnection(String url) throws SQLException {
        ConnectionFactory.loadDriver(url);
        return DriverManager.getConnection(url);
    }

    public static Connection getConnection(String url, Properties info) throws SQLException {
        ConnectionFactory.loadDriver(url);
        return DriverManager.getConnection(url, info);
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        ConnectionFactory.loadDriver(url);
        return DriverManager.getConnection(url, user, password);
    }

    public static void loadDriver(String url) throws SQLException {
        block8: {
            Matcher matcher = GET_SUBPROTOCOL.matcher(url);
            if (matcher.matches()) {
                List<String> drivers = DRIVERS.get(matcher.group(1).toLowerCase());
                if (drivers != null) {
                    for (int i = 0; i < drivers.size(); ++i) {
                        String subDriver = drivers.get(i);
                        try {
                            Class.forName(subDriver);
                            return;
                        }
                        catch (ClassNotFoundException e) {
                            continue;
                        }
                    }
                    throw new SQLException("Driver(s) [" + StringUtils.join(drivers, ",") + "] not found in classpath");
                }
                try {
                    if (DriverManager.getDriver(url) == null) {
                        throw new SQLException("No JDBC driver know for this connection url: " + url);
                    }
                    break block8;
                }
                catch (SQLException ex) {
                    throw new SQLException("No JDBC driver know for this connection url: " + url);
                }
            }
            throw new SQLException("Cannot parse connection string: " + url);
        }
    }

    public static void add(String type, String driver) {
        List<String> cur = DRIVERS.get(type);
        if (cur == null) {
            cur = new ArrayList<String>();
            DRIVERS.put(type, cur);
        }
        cur.add(driver);
    }

    static {
        ConnectionFactory.add("postgresql", "org.postgresql.Driver");
        ConnectionFactory.add("postgres", "postgresql.Driver");
        ConnectionFactory.add("postgresql_postgis", "org.postgis.DriverWrapper");
        ConnectionFactory.add("db2", "COM.ibm.db2.jdbc.app.DB2Driver");
        ConnectionFactory.add("odbc", "sun.jdbc.odbc.JdbcOdbcDriver");
        ConnectionFactory.add("weblogic", "weblogic.jdbc.mssqlserver4.Driver");
        ConnectionFactory.add("oracle", "oracle.jdbc.driver.OracleDriver");
        ConnectionFactory.add("pointbase", "com.pointbase.jdbc.jdbcUniversalDriver");
        ConnectionFactory.add("cloudscape", "COM.cloudscape.core.JDBCDriver");
        ConnectionFactory.add("rmi", "RmiJdbc.RJDriver");
        ConnectionFactory.add("firebirdsql", "org.firebirdsql.jdbc.FBDriver");
        ConnectionFactory.add("ids", "ids.sql.IDSDriver");
        ConnectionFactory.add("informix-sqli", "com.informix.jdbc.IfxDriver");
        ConnectionFactory.add("idb", "org.enhydra.instantdb.jdbc.idbDriver");
        ConnectionFactory.add("interbase", "interbase.interclient.Driver");
        ConnectionFactory.add("HypersonicSQL", "org.hsql.jdbcDriver");
        ConnectionFactory.add("HypersonicSQL", "hSql.hDriver");
        ConnectionFactory.add("JTurbo", "com.ashna.jturbo.driver.Driver");
        ConnectionFactory.add("inetdae", "com.inet.tds.TdsDriver");
        ConnectionFactory.add("microsoft", "com.microsoft.jdbc.sqlserver.SQLServerDriver");
        ConnectionFactory.add("mysql", "org.gjt.mm.mysql.Driver");
        ConnectionFactory.add("sybase", "com.sybase.jdbc2.jdbc.SybDriver");
        ConnectionFactory.add("sybase", "com.sybase.jdbc.SybDriver");
    }
}

