/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pvalsecc.misc.UnitUtilities;

public abstract class JdbcUtilities {
    public static final Log LOGGER = LogFactory.getLog(JdbcUtilities.class);
    public static final Log TIMING_LOGGER = LogFactory.getLog(JdbcUtilities.class.getName() + ".timing");

    public static void safeClose(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ignored) {
            LOGGER.warn("Could not close properly a JDBC result set!");
        }
    }

    public static void safeClose(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException ignored) {
            LOGGER.warn("Could not close properly a JDBC statement!");
        }
    }

    public static void safeClose(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException ignored) {
            LOGGER.warn("Could not close properly a JDBC connection!");
        }
    }

    public static void runSelectQuery(String description, String sqlStatement, Connection conn, SelectTask task) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean queryDisplayed = false;
        try {
            stmt = conn.prepareStatement(sqlStatement, 1003, 1007);
            stmt.setFetchSize(500);
            task.setupStatement(stmt);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing SQL : " + sqlStatement + " (" + description + ")");
                queryDisplayed = true;
            }
            long beginTime = System.currentTimeMillis();
            rs = stmt.executeQuery();
            long middleTime = System.currentTimeMillis();
            if (TIMING_LOGGER.isDebugEnabled()) {
                TIMING_LOGGER.debug("Time " + description + " (executeQuery): " + UnitUtilities.toElapsedTime(middleTime - beginTime));
            }
            task.run(rs);
            if (TIMING_LOGGER.isDebugEnabled()) {
                TIMING_LOGGER.debug("Time " + description + " (read): " + UnitUtilities.toElapsedTime(System.currentTimeMillis() - middleTime));
            }
        }
        catch (SQLException ex) {
            try {
                if (!queryDisplayed) {
                    LOGGER.error(sqlStatement);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                JdbcUtilities.safeClose(rs);
                JdbcUtilities.safeClose(stmt);
                throw throwable;
            }
        }
        JdbcUtilities.safeClose(rs);
        JdbcUtilities.safeClose(stmt);
    }

    public static long countTable(Connection con, String tableName, final DeleteTask task) throws SQLException {
        final long[] result = new long[1];
        JdbcUtilities.runSelectQuery("counting table " + tableName, "SELECT count(*) FROM " + tableName, con, new SelectTask(){

            @Override
            public void setupStatement(PreparedStatement stmt) throws SQLException {
                if (task != null) {
                    task.setupStatement(stmt);
                }
            }

            @Override
            public void run(ResultSet rs) throws SQLException {
                if (!rs.next()) {
                    throw new SQLException("didn't return any result");
                }
                result[0] = rs.getLong(1);
                if (rs.next()) {
                    throw new SQLException("returned more than one result");
                }
            }
        });
        return result[0];
    }

    public static int runDeleteQuery(String description, String sqlStatement, Connection conn, DeleteTask task) throws SQLException {
        PreparedStatement stmt = null;
        boolean queryDisplayed = false;
        try {
            stmt = conn.prepareStatement(sqlStatement);
            if (task != null) {
                task.setupStatement(stmt);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing SQL : " + sqlStatement + " (" + description + ")");
                queryDisplayed = true;
            }
            long beginTime = System.currentTimeMillis();
            boolean type = stmt.execute();
            if (type) {
                throw new RuntimeException("Delete statement returning a result set?");
            }
            int count = stmt.getUpdateCount();
            if (TIMING_LOGGER.isDebugEnabled()) {
                if (count > 0) {
                    TIMING_LOGGER.debug("Time " + description + " (count=" + count + "): " + UnitUtilities.toElapsedTime(System.currentTimeMillis() - beginTime));
                } else {
                    TIMING_LOGGER.debug("Time " + description + ": " + UnitUtilities.toElapsedTime(System.currentTimeMillis() - beginTime));
                }
            }
            int n = count;
            return n;
        }
        catch (SQLException ex) {
            if (!queryDisplayed) {
                LOGGER.error(sqlStatement);
            }
            throw ex;
        }
        finally {
            JdbcUtilities.safeClose(stmt);
        }
    }

    public static <T> void runInsertQuery(String description, String sqlStatement, Connection conn, Iterator<T> items, int batchSize, InsertTask<T> task) throws SQLException {
        PreparedStatement stmt = null;
        try {
            long beginTime = System.currentTimeMillis();
            stmt = conn.prepareStatement(sqlStatement);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing SQL : " + sqlStatement + " (" + description + ")");
            }
            int idx = 0;
            int cpt = 0;
            while (items.hasNext()) {
                T item = items.next();
                if (!task.marshall(stmt, item)) continue;
                stmt.addBatch();
                if (++idx >= batchSize) {
                    stmt.executeBatch();
                    idx = 0;
                }
                ++cpt;
            }
            if (idx > 0) {
                stmt.executeBatch();
            }
            if (TIMING_LOGGER.isDebugEnabled()) {
                TIMING_LOGGER.debug("Time " + description + " (" + cpt + " records): " + UnitUtilities.toElapsedTime(System.currentTimeMillis() - beginTime));
            }
        }
        catch (BatchUpdateException ex) {
            try {
                LOGGER.error(ex.getNextException());
                throw ex;
            }
            catch (Throwable throwable) {
                JdbcUtilities.safeClose(stmt);
                throw throwable;
            }
        }
        JdbcUtilities.safeClose(stmt);
    }

    public static <T> void runInsertQuery(String description, String sqlStatement, Connection conn, Iterable<T> items, int batchSize, InsertTask<T> task) throws SQLException {
        JdbcUtilities.runInsertQuery(description, sqlStatement, conn, items.iterator(), batchSize, task);
    }

    public static interface InsertTask<T> {
        public boolean marshall(PreparedStatement var1, T var2) throws SQLException;
    }

    public static interface DeleteTask {
        public void setupStatement(PreparedStatement var1) throws SQLException;
    }

    public static interface SelectTask {
        public void setupStatement(PreparedStatement var1) throws SQLException;

        public void run(ResultSet var1) throws SQLException;
    }
}

