/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.log;

import org.apache.commons.logging.Log;
import org.pvalsecc.misc.UnitUtilities;

public class Progress {
    private static final double GROW_FACTOR = 0.7;
    private static final double SHRINK_FACTOR = 0.2;
    private long reportFrequency;
    private int target;
    private String description;
    private Log logger;
    private int cur = 0;
    private long nextReporting;
    private int prevReportValue;
    private double prevPeriodForOne;

    public Progress(long reportFrequency, int target, String description, Log logger) {
        this.reportFrequency = reportFrequency;
        this.target = target;
        this.description = description;
        this.logger = logger;
        this.nextReporting = System.currentTimeMillis() + reportFrequency;
        this.prevReportValue = 0;
        this.prevPeriodForOne = 0.0;
    }

    public void update(int cur) {
        long now;
        this.cur = cur;
        if (this.logger.isInfoEnabled() && (now = System.currentTimeMillis()) >= this.nextReporting) {
            this.doReporting(now, cur);
        }
    }

    private void doReporting(long now, int cur) {
        this.logger.info(this.description + " " + (long)cur * 100L / (long)this.target + "% done, approx. " + UnitUtilities.toElapsedTime(this.computeRemaingTime(now, cur)) + " remaining.");
        this.nextReporting = now + this.reportFrequency;
        this.prevReportValue = cur;
    }

    private long computeRemaingTime(long now, int cur) {
        long timeSinceLastReport = now - (this.nextReporting - this.reportFrequency);
        int nbSinceLastReport = cur - this.prevReportValue;
        long nbRemaining = this.target - cur;
        if (nbSinceLastReport > 0) {
            double curPeriodForOne = (double)timeSinceLastReport / (double)nbSinceLastReport;
            this.prevPeriodForOne = this.prevPeriodForOne == 0.0 ? curPeriodForOne : (this.prevPeriodForOne > curPeriodForOne ? this.prevPeriodForOne * 0.8 + curPeriodForOne * 0.2 : this.prevPeriodForOne * 0.30000000000000004 + curPeriodForOne * 0.7);
        }
        return Math.round((double)nbRemaining * this.prevPeriodForOne);
    }

    public int getCur() {
        return this.cur;
    }
}

