/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.misc;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class URIUtils {
    public static Map<String, List<String>> getParameters(URI uri) throws URISyntaxException, UnsupportedEncodingException {
        return URIUtils.getParameters(uri.getRawQuery());
    }

    public static Map<String, List<String>> getParameters(String rawQuery) throws URISyntaxException, UnsupportedEncodingException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (rawQuery == null) {
            return result;
        }
        StringTokenizer tokens = new StringTokenizer(rawQuery, "&");
        while (tokens.hasMoreTokens()) {
            String pair = tokens.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new URISyntaxException(rawQuery, "Cannot find '=' sign");
            }
            String key = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
            String value = URLDecoder.decode(pair.substring(pos + 1, pair.length()), "UTF-8");
            URIUtils.addParam(result, key, value);
        }
        return result;
    }

    public static URI addParams(URI uri, Map<String, List<String>> params, Set<String> overridenParams) throws URISyntaxException, UnsupportedEncodingException {
        String key;
        if (params == null || params.size() == 0) {
            return uri;
        }
        String origTxt = uri.toString();
        int queryStart = origTxt.indexOf(63);
        StringBuilder result = new StringBuilder();
        if (queryStart < 0) {
            int fragmentStart = origTxt.indexOf(35);
            if (fragmentStart < 0) {
                result.append(origTxt);
            } else {
                result.append(origTxt.substring(0, fragmentStart));
            }
        } else {
            result.append(origTxt.substring(0, queryStart));
        }
        Map<String, List<String>> origParams = URIUtils.getParameters(uri);
        boolean first = true;
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            key = param.getKey();
            List<String> origList = origParams.remove(key);
            if (!(origList == null || overridenParams != null && overridenParams.contains(key))) {
                first = URIUtils.addParams(result, first, key, origList);
            }
            List<String> list = param.getValue();
            first = URIUtils.addParams(result, first, key, list);
        }
        for (Map.Entry<String, List<String>> param : origParams.entrySet()) {
            key = param.getKey();
            List<String> list = param.getValue();
            first = URIUtils.addParams(result, first, key, list);
        }
        if (uri.getFragment() != null) {
            result.append('#').append(uri.getRawFragment());
        }
        return new URI(result.toString());
    }

    private static boolean addParams(StringBuilder result, boolean first, String key, List<String> list) throws UnsupportedEncodingException {
        for (int i = 0; i < list.size(); ++i) {
            String val = list.get(i);
            if (first) {
                result.append('?');
                first = false;
            } else {
                result.append('&');
            }
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(val, "UTF-8"));
        }
        return first;
    }

    public static void addParam(Map<String, List<String>> params, String key, String value) {
        List<String> list = params.get(key);
        if (list == null) {
            list = new ArrayList<String>(1);
            params.put(key, list);
        }
        list.add(value);
    }

    public static void addParamOverride(Map<String, List<String>> params, String key, String value) {
        ArrayList<String> list = new ArrayList<String>(1);
        params.put(key, list);
        list.add(value);
    }
}

