/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterTransformer;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.referencing.CRS;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.Extent;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.OtherText;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.UserLayer;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.ContrastMethod;
import org.opengis.style.SemanticType;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SLDTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.styling");
    static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private final Map uri2prefix;

    public SLDTransformer() {
        this(null);
    }

    public SLDTransformer(Map nsBindings) {
        if (nsBindings == null || nsBindings.isEmpty()) {
            this.uri2prefix = new HashMap();
        } else {
            this.uri2prefix = new HashMap(nsBindings.size());
            int count = 0;
            for (Map.Entry e : nsBindings.entrySet()) {
                URI uri = (URI)e.getKey();
                String prefix = (String)e.getValue();
                if (uri == null || prefix == null) continue;
                this.uri2prefix.put(uri, prefix.trim());
                ++count;
            }
            LOGGER.info("Added [" + count + "] namespace entries resulting in [" + this.uri2prefix.size() + "] distinct entries");
        }
    }

    @Override
    public Translator createTranslator(ContentHandler handler) {
        SLDTranslator result = new SLDTranslator(handler);
        if (!this.uri2prefix.isEmpty()) {
            for (Map.Entry e : this.uri2prefix.entrySet()) {
                URI uri = (URI)e.getKey();
                if (uri == null) continue;
                String prefix = (String)e.getValue();
                String uriStr = String.valueOf(uri);
                result.getNamespaceSupport().declarePrefix(prefix, uriStr);
            }
        }
        return result;
    }

    public static final void main(String[] args) throws Exception {
        URL url = new File(args[0]).toURI().toURL();
        SLDParser s = new SLDParser(CommonFactoryFinder.getStyleFactory(null), url);
        SLDTransformer transformer = new SLDTransformer();
        transformer.setIndentation(4);
        transformer.transform((Object)s.readXML(), new FileOutputStream(System.getProperty("java.io.tmpdir") + "/junk.eraseme"));
    }

    static class SLDTranslator
    extends TransformerBase.TranslatorSupport
    implements StyleVisitor {
        FilterTransformer.FilterTranslator filterTranslator;

        public SLDTranslator(ContentHandler handler) {
            this(handler, "sld", "http://www.opengis.net/sld");
        }

        public SLDTranslator(ContentHandler handler, String prefix, String uri) {
            super(handler, prefix, uri);
            this.filterTranslator = new FilterTransformer.FilterTranslator(handler);
            this.addNamespaceDeclarations(this.filterTranslator);
        }

        boolean isNull(Expression expr) {
            if (expr == null) {
                return true;
            }
            if (expr == Expression.NIL) {
                return true;
            }
            if (expr instanceof Literal) {
                Literal literal = (Literal)expr;
                return literal.getValue() == null;
            }
            return false;
        }

        boolean isDefault(Expression expr, Object defaultValue) {
            if (defaultValue == null) {
                return this.isNull(expr);
            }
            if (expr == null) {
                return false;
            }
            if (expr == Expression.NIL) {
                return false;
            }
            if (expr instanceof Literal) {
                Literal literal = (Literal)expr;
                if (defaultValue.equals(literal.getValue())) {
                    return true;
                }
                if (defaultValue.toString().equals(literal.getValue().toString())) {
                    return true;
                }
            }
            return false;
        }

        void element(String element, Expression expr) {
            this.element(element, expr, null);
        }

        void element(String element, Expression expr, Object defaultValue) {
            this.element(element, expr, defaultValue, null);
        }

        void element(String element, Expression expr, Object defaultValue, AttributesImpl atts) {
            if (expr == null || expr == Expression.NIL) {
                return;
            }
            if (expr instanceof Literal) {
                if (defaultValue != null) {
                    Object value = expr.evaluate(null, defaultValue.getClass());
                    if (value != null && !value.equals(defaultValue)) {
                        this.element(element, value.toString(), atts);
                    }
                } else {
                    String value = expr.evaluate(null, String.class);
                    if (value != null) {
                        this.element(element, value, atts);
                    }
                }
                return;
            }
            this.start(element, atts);
            this.filterTranslator.encode(expr);
            this.end(element);
        }

        void elementLiteral(String element, Expression e, String defaultValue) {
            if (e == null || e == Expression.NIL) {
                return;
            }
            String value = e.evaluate(null, String.class);
            if (defaultValue == null || !defaultValue.equals(value)) {
                this.start(element);
                this.start(value);
                this.end(value);
                this.end(element);
            }
        }

        @Override
        public void visit(PointPlacement pp) {
            this.start("LabelPlacement");
            this.start("PointPlacement");
            pp.getAnchorPoint().accept(this);
            this.visit(pp.getDisplacement());
            this.encodeValue("Rotation", null, pp.getRotation(), 0.0);
            this.end("PointPlacement");
            this.end("LabelPlacement");
        }

        @Override
        public void visit(Stroke stroke) {
            this.start("Stroke");
            if (stroke.getGraphicFill() != null) {
                this.start("GraphicFill");
                stroke.getGraphicFill().accept(this);
                this.end("GraphicFill");
            }
            if (stroke.getGraphicStroke() != null) {
                this.start("GraphicStroke");
                stroke.getGraphicStroke().accept(this);
                this.end("GraphicStroke");
            }
            this.encodeCssParam("stroke", stroke.getColor(), Color.BLACK);
            this.encodeCssParam("stroke-linecap", stroke.getLineCap(), "butt");
            this.encodeCssParam("stroke-linejoin", stroke.getLineJoin(), "miter");
            this.encodeCssParam("stroke-opacity", stroke.getOpacity(), 1.0);
            this.encodeCssParam("stroke-width", stroke.getWidth(), 1.0);
            this.encodeCssParam("stroke-dashoffset", stroke.getDashOffset(), 0.0);
            float[] dash = stroke.getDashArray();
            if (dash != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < dash.length; ++i) {
                    sb.append(dash[i]);
                    if (i >= dash.length - 1) continue;
                    sb.append(" ");
                }
                this.encodeCssParam("stroke-dasharray", ff.literal(sb.toString()));
            }
            this.end("Stroke");
        }

        @Override
        public void visit(LinePlacement lp) {
            this.start("LabelPlacement");
            this.start("LinePlacement");
            this.element("PerpendicularOffset", lp.getPerpendicularOffset());
            this.end("LinePlacement");
            this.end("LabelPlacement");
        }

        @Override
        public void visit(AnchorPoint ap) {
            this.start("AnchorPoint");
            this.element("AnchorPointX", ap.getAnchorPointX());
            this.element("AnchorPointY", ap.getAnchorPointY());
            this.end("AnchorPoint");
        }

        @Override
        public void visit(TextSymbolizer text) {
            if (text == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            Unit<Length> uom = text.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get(uom).getSEString());
            }
            this.start("TextSymbolizer", atts);
            this.encodeGeometryExpression(text.getGeometry());
            if (text.getLabel() != null) {
                this.element("Label", text.getLabel());
            }
            if (text.getFonts() != null && text.getFonts().length != 0) {
                this.start("Font");
                Font[] fonts = text.getFonts();
                for (int i = 0; i < fonts.length; ++i) {
                    this.encodeCssParam("font-family", fonts[i].getFontFamily());
                }
                this.encodeCssParam("font-size", fonts[0].getFontSize());
                this.encodeCssParam("font-style", fonts[0].getFontStyle());
                this.encodeCssParam("font-weight", fonts[0].getFontWeight());
                this.end("Font");
            }
            if (text.getPlacement() != null) {
                text.getPlacement().accept(this);
            }
            if (text.getHalo() != null) {
                text.getHalo().accept(this);
            }
            if (text.getFill() != null) {
                text.getFill().accept(this);
            }
            if (text instanceof TextSymbolizer2) {
                OtherText otherText;
                TextSymbolizer2 text2 = (TextSymbolizer2)text;
                if (text2.getGraphic() != null) {
                    this.visit(text2.getGraphic());
                }
                if (text2.getSnippet() != null) {
                    this.element("Snippet", text2.getSnippet());
                }
                if (text2.getFeatureDescription() != null) {
                    this.element("FeatureDescription", text2.getFeatureDescription());
                }
                if ((otherText = text2.getOtherText()) != null) {
                    AttributesImpl otherTextAtts = new AttributesImpl();
                    otherTextAtts.addAttribute("", "target", "target", "", otherText.getTarget());
                    this.element("OtherText", otherText.getText(), null, otherTextAtts);
                }
            }
            if (text.getPriority() != null) {
                this.element("Priority", text.getPriority());
            }
            if (text.getOptions() != null) {
                this.encodeVendorOptions(text.getOptions());
            }
            this.end("TextSymbolizer");
        }

        @Override
        public void visit(RasterSymbolizer raster) {
            ColorMap colorMap;
            if (raster == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            Unit<Length> uom = raster.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get(uom).getSEString());
            }
            this.start("RasterSymbolizer", atts);
            this.encodeGeometryExpression(raster.getGeometry());
            this.element("Opacity", raster.getOpacity(), 1.0);
            if (raster.getChannelSelection() != null) {
                ChannelSelection cs = raster.getChannelSelection();
                if (cs.getGrayChannel() != null) {
                    this.start("ChannelSelection");
                    SelectedChannelType gray = cs.getGrayChannel();
                    this.start("GrayChannel");
                    gray.accept(this);
                    this.end("GrayChannel");
                    this.end("ChannelSelection");
                } else if (cs.getRGBChannels() != null && cs.getRGBChannels().length == 3 && cs.getRGBChannels()[0] != null && cs.getRGBChannels()[1] != null && cs.getRGBChannels()[2] != null) {
                    this.start("ChannelSelection");
                    SelectedChannelType[] rgb = cs.getRGBChannels();
                    this.start("RedChannel");
                    rgb[0].accept(this);
                    this.end("RedChannel");
                    this.start("GreenChannel");
                    rgb[1].accept(this);
                    this.end("GreenChannel");
                    this.start("BlueChannel");
                    rgb[2].accept(this);
                    this.end("BlueChannel");
                    this.end("ChannelSelection");
                }
            }
            if (raster.getOverlap() != null) {
                Expression overlaps = raster.getOverlap();
                if (overlaps instanceof PropertyName) {
                    String pn = ((PropertyName)overlaps).getPropertyName();
                    if ("RANDOM".equals(pn)) {
                        this.start("OverlapBehavior");
                        this.start(pn);
                        this.end(pn);
                        this.end("OverlapBehavior");
                    }
                } else {
                    this.elementLiteral("OverlapBehavior", overlaps, "RANDOM");
                }
            }
            if ((colorMap = raster.getColorMap()) != null && colorMap.getColorMapEntries() != null && colorMap.getColorMapEntries().length > 0) {
                colorMap.accept(this);
            }
            if (raster.getContrastEnhancement() != null) {
                raster.getContrastEnhancement().accept(this);
            }
            if (raster.getShadedRelief() != null) {
                raster.getShadedRelief().accept(this);
            }
            if (raster.getImageOutline() != null) {
                this.start("ImageOutline");
                raster.getImageOutline().accept(this);
                this.end("ImageOutline");
            }
            this.end("RasterSymbolizer");
        }

        @Override
        public void visit(ColorMap colorMap) {
            boolean extended;
            AttributesImpl atts = new AttributesImpl();
            String typeString = colorMap.getType() == 2 ? "intervals" : (colorMap.getType() == 3 ? "values" : "ramp");
            if (!"ramp".equals(typeString)) {
                atts.addAttribute("", "type", "type", "", typeString);
            }
            if (extended = colorMap.getExtendedColors()) {
                atts.addAttribute("", "extended", "extended", "", "" + extended);
            }
            this.start("ColorMap", atts);
            ColorMapEntry[] mapEntries = colorMap.getColorMapEntries();
            for (int i = 0; i < mapEntries.length; ++i) {
                mapEntries[i].accept(this);
            }
            this.end("ColorMap");
        }

        @Override
        public void visit(ColorMapEntry colorEntry) {
            if (colorEntry != null) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "color", "color", "", colorEntry.getColor().evaluate(null, String.class));
                if (colorEntry.getOpacity() != null) {
                    atts.addAttribute("", "opacity", "opacity", "", colorEntry.getOpacity().toString());
                }
                if (colorEntry.getQuantity() != null) {
                    atts.addAttribute("", "quantity", "quantity", "", colorEntry.getQuantity().toString());
                }
                if (colorEntry.getLabel() != null) {
                    atts.addAttribute("", "label", "label", "", colorEntry.getLabel());
                }
                this.element("ColorMapEntry", (String)null, atts);
            }
        }

        @Override
        public void visit(Symbolizer sym2) {
            try {
                this.contentHandler.startElement("", "!--", "!--", this.NULL_ATTS);
                this.chars("Unidentified Symbolizer " + sym2.getClass());
                this.contentHandler.endElement("", "--", "--");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        @Override
        public void visit(PolygonSymbolizer poly) {
            AttributesImpl atts = new AttributesImpl();
            Unit<Length> uom = poly.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get(uom).getSEString());
            }
            this.start("PolygonSymbolizer", atts);
            this.encodeGeometryExpression(poly.getGeometry());
            if (poly.getFill() != null) {
                poly.getFill().accept(this);
            }
            if (poly.getStroke() != null) {
                poly.getStroke().accept(this);
            }
            if (poly.getOptions() != null) {
                this.encodeVendorOptions(poly.getOptions());
            }
            this.end("PolygonSymbolizer");
        }

        @Override
        public void visit(ExternalGraphic exgr) {
            this.start("ExternalGraphic");
            AttributesImpl atts = new AttributesImpl();
            try {
                atts.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", "", SLDTransformer.XLINK_NAMESPACE);
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "type", "xlink:type", "", "simple");
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "xlink", "xlink:href", "", exgr.getLocation().toString());
            }
            catch (MalformedURLException e) {
                throw new Error("Failed to encode the xlink location", e);
            }
            this.element("OnlineResource", (String)null, atts);
            this.element("Format", exgr.getFormat());
            this.end("ExternalGraphic");
        }

        @Override
        public void visit(LineSymbolizer line) {
            AttributesImpl atts = new AttributesImpl();
            Unit<Length> uom = line.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get(uom).getSEString());
            }
            this.start("LineSymbolizer", atts);
            this.encodeGeometryExpression(line.getGeometry());
            if (line.getStroke() != null) {
                line.getStroke().accept(this);
            }
            if (line.getOptions() != null) {
                this.encodeVendorOptions(line.getOptions());
            }
            if (line.getPerpendicularOffset() != null) {
                this.element("PerpendicularOffset", line.getPerpendicularOffset() + "");
            }
            this.end("LineSymbolizer");
        }

        @Override
        public void visit(Fill fill) {
            this.start("Fill");
            if (fill.getGraphicFill() != null) {
                this.start("GraphicFill");
                fill.getGraphicFill().accept(this);
                this.end("GraphicFill");
            }
            this.encodeCssParam("fill", fill.getColor(), "#808080");
            this.encodeCssParam("fill-opacity", fill.getOpacity(), 1.0);
            this.end("Fill");
        }

        @Override
        public void visit(Rule rule) {
            this.start("Rule");
            if (rule.getName() != null) {
                this.element("Name", rule.getName());
            }
            if (rule.getTitle() != null) {
                this.element("Title", rule.getTitle());
            }
            if (rule.getAbstract() != null) {
                this.element("Abstract", rule.getAbstract());
            }
            Graphic[] gr = rule.getLegendGraphic();
            for (int i = 0; i < gr.length; ++i) {
                this.start("LegendGraphic");
                gr[i].accept(this);
                this.end("LegendGraphic");
            }
            Filter filter = rule.getFilter();
            if (filter != null && filter != Filter.INCLUDE) {
                this.visit(filter);
            }
            if (rule.isElseFilter()) {
                this.start("ElseFilter");
                this.end("ElseFilter");
            }
            if (rule.getMinScaleDenominator() != 0.0) {
                this.element("MinScaleDenominator", rule.getMinScaleDenominator() + "");
            }
            if (rule.getMaxScaleDenominator() != Double.POSITIVE_INFINITY) {
                this.element("MaxScaleDenominator", rule.getMaxScaleDenominator() + "");
            }
            Symbolizer[] sym2 = rule.getSymbolizers();
            for (int i = 0; i < sym2.length; ++i) {
                sym2[i].accept(this);
            }
            this.end("Rule");
        }

        @Override
        public void visit(Mark mark) {
            this.start("Mark");
            if (mark.getWellKnownName() != null && !"square".equals(mark.getWellKnownName().evaluate(null))) {
                this.element("WellKnownName", mark.getWellKnownName().toString());
            }
            if (mark.getFill() != null) {
                mark.getFill().accept(this);
            }
            if (mark.getStroke() != null) {
                mark.getStroke().accept(this);
            }
            this.end("Mark");
        }

        @Override
        public void visit(PointSymbolizer ps) {
            AttributesImpl atts = new AttributesImpl();
            Unit<Length> uom = ps.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get(uom).getSEString());
            }
            this.start("PointSymbolizer", atts);
            this.encodeGeometryExpression(ps.getGeometry());
            ps.getGraphic().accept(this);
            if (ps.getOptions() != null) {
                this.encodeVendorOptions(ps.getOptions());
            }
            this.end("PointSymbolizer");
        }

        @Override
        public void visit(Halo halo) {
            this.start("Halo");
            if (halo.getRadius() != null) {
                this.encodeValue("Radius", null, halo.getRadius(), null);
            }
            if (halo.getFill() != null) {
                halo.getFill().accept(this);
            }
            this.end("Halo");
        }

        @Override
        public void visit(Graphic gr) {
            this.start("Graphic");
            Symbol[] symbols = gr.getSymbols();
            for (int i = 0; i < symbols.length; ++i) {
                symbols[i].accept(this);
            }
            this.element("Opacity", gr.getOpacity(), 1.0);
            this.element("Size", gr.getSize());
            this.element("Rotation", gr.getRotation(), 0.0);
            this.visit(gr.getDisplacement());
            this.end("Graphic");
        }

        @Override
        public void visit(StyledLayerDescriptor sld) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "version", "version", "", "1.0.0");
            this.start("StyledLayerDescriptor", atts);
            if (sld.getName() != null && sld.getName().length() > 0) {
                this.element("Name", sld.getName());
            }
            if (sld.getTitle() != null && sld.getTitle().length() > 0) {
                this.element("Title", sld.getTitle());
            }
            if (sld.getAbstract() != null && sld.getAbstract().length() > 0) {
                this.element("Abstract", sld.getAbstract());
            }
            StyledLayer[] layers = sld.getStyledLayers();
            for (int i = 0; i < layers.length; ++i) {
                if (layers[i] instanceof NamedLayer) {
                    this.visit((NamedLayer)layers[i]);
                    continue;
                }
                if (layers[i] instanceof UserLayer) {
                    this.visit((UserLayer)layers[i]);
                    continue;
                }
                throw new IllegalArgumentException("StyledLayer '" + layers[i].getClass().toString() + "' not found");
            }
            this.end("StyledLayerDescriptor");
        }

        @Override
        public void visit(NamedLayer layer) {
            this.start("NamedLayer");
            this.element("Name", layer.getName());
            FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
            if (lfc != null && lfc.length > 0) {
                this.start("LayerFeatureConstraints");
                for (int i = 0; i < lfc.length; ++i) {
                    this.visit(lfc[i]);
                }
                this.end("LayerFeatureConstraints");
            }
            Style[] styles = layer.getStyles();
            for (int i = 0; i < styles.length; ++i) {
                this.visit(styles[i]);
            }
            this.end("NamedLayer");
        }

        @Override
        public void visit(UserLayer layer) {
            DataStore inlineFDS;
            this.start("UserLayer");
            if (layer.getName() != null && layer.getName().length() > 0) {
                this.element("Name", layer.getName());
            }
            if ((inlineFDS = layer.getInlineFeatureDatastore()) != null) {
                this.visitInlineFeatureType(inlineFDS, layer.getInlineFeatureType());
            } else if (layer.getRemoteOWS() != null) {
                this.visit(layer.getRemoteOWS());
            }
            this.start("LayerFeatureConstraints");
            FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
            if (lfc != null && lfc.length > 0) {
                for (int i = 0; i < lfc.length; ++i) {
                    this.visit(lfc[i]);
                }
            } else {
                this.start("FeatureTypeConstraint");
                this.end("FeatureTypeConstraint");
            }
            this.end("LayerFeatureConstraints");
            Style[] styles = layer.getUserStyles();
            for (int i = 0; i < styles.length; ++i) {
                this.visit(styles[i]);
            }
            this.end("UserLayer");
        }

        private void visitInlineFeatureType(DataStore dataStore, SimpleFeatureType featureType) {
            this.start("InlineFeature");
            try {
                String ftName = featureType.getTypeName();
                SimpleFeatureSource fs = dataStore.getFeatureSource(ftName);
                SimpleFeatureCollection fc = fs.getFeatures();
                FeatureTransformer ftrax = new FeatureTransformer();
                ftrax.setCollectionNamespace(null);
                ftrax.setCollectionPrefix(null);
                ftrax.setGmlPrefixing(true);
                ftrax.setIndentation(2);
                CoordinateReferenceSystem crs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
                String srsName = null;
                if (crs == null) {
                    LOGGER.warning("Null CRS in feature type named [" + ftName + "]. Ignore CRS");
                } else {
                    int ndx;
                    srsName = CRS.toSRS(crs, true);
                    if (srsName == null) {
                        Set<ReferenceIdentifier> ids = crs.getIdentifiers();
                        if (ids == null || ids.isEmpty()) {
                            LOGGER.warning("Null or empty set of named identifiers in CRS [" + crs + "] of feature type named [" + ftName + "]. Ignore CRS");
                        } else {
                            for (ReferenceIdentifier id : ids) {
                                if (id == null) continue;
                                srsName = String.valueOf(id);
                                break;
                            }
                        }
                    }
                    if (srsName != null && (ndx = srsName.indexOf(58)) > 0) {
                        LOGGER.info("Reducing CRS name [" + srsName + "] to its SRID");
                        srsName = srsName.substring(ndx + 1).trim();
                    }
                }
                if (srsName != null) {
                    ftrax.setSrsName(srsName);
                }
                String defaultNS = this.getDefaultNamespace();
                ftrax.getFeatureTypeNamespaces().declareDefaultNamespace("", defaultNS);
                String ns = featureType.getName().getNamespaceURI();
                if (ns == null) {
                    LOGGER.info("Null namespace URI in feature type named [" + ftName + "]. Ignore namespace in features");
                } else {
                    String prefix = this.nsSupport.getPrefix(ns);
                    if (prefix != null) {
                        ftrax.getFeatureTypeNamespaces().declareNamespace(featureType, prefix, ns);
                    }
                }
                Translator t = ftrax.createTranslator(this.contentHandler);
                t.encode(fc);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.end("InlineFeature");
        }

        public void visit(RemoteOWS remoteOWS) {
            this.start("RemoteOWS");
            this.element("Service", remoteOWS.getService());
            this.element("OnlineResource", remoteOWS.getOnlineResource());
            this.end("RemoteOWS");
        }

        @Override
        public void visit(FeatureTypeConstraint ftc) {
            this.start("FeatureTypeConstraint");
            if (ftc != null) {
                this.element("FeatureTypeName", ftc.getFeatureTypeName());
                this.visit(ftc.getFilter());
                Extent[] extent = ftc.getExtents();
                for (int i = 0; i < extent.length; ++i) {
                    this.visit(extent[i]);
                }
            }
            this.end("FeatureTypeConstraint");
        }

        public void visit(Extent extent) {
            this.start("Extent");
            this.element("Name", extent.getName());
            this.element("Value", extent.getValue());
            this.end("Extent");
        }

        public void visit(Filter filter) {
            try {
                this.contentHandler.startElement("", "", "ogc:Filter", this.NULL_ATTS);
                this.filterTranslator.encode(filter);
                this.contentHandler.endElement("", "", "ogc:Filter");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        @Override
        public void visit(Style style) {
            if (style instanceof NamedStyle) {
                this.start("NamedStyle");
                this.element("Name", style.getName());
                this.end("NamedStyle");
            } else {
                this.start("UserStyle");
                this.element("Name", style.getName());
                this.element("Title", style.getTitle());
                if (style.isDefault()) {
                    this.element("IsDefault", "1");
                }
                this.elementSafe("Abstract", style.getAbstract());
                FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
                for (int i = 0; i < fts.length; ++i) {
                    this.visit(fts[i]);
                }
                this.end("UserStyle");
            }
        }

        @Override
        public void visit(FeatureTypeStyle fts) {
            String[] sti;
            this.start("FeatureTypeStyle");
            if (fts.getName() != null && fts.getName().length() > 0) {
                this.element("Name", fts.getName());
            }
            if (fts.getTitle() != null && fts.getTitle().length() > 0) {
                this.element("Title", fts.getTitle());
            }
            if (fts.getAbstract() != null && fts.getAbstract().length() > 0) {
                this.element("Abstract", fts.getAbstract());
            }
            if (fts.featureTypeNames() != null && fts.featureTypeNames().size() > 0) {
                this.element("FeatureTypeName", ((Object)fts.featureTypeNames().iterator().next()).toString());
            }
            if (fts.getTransformation() != null) {
                this.element("Transformation", fts.getTransformation());
            }
            if ((sti = fts.getSemanticTypeIdentifiers()).length != 1 || !sti[0].equals(SemanticType.ANY.toString())) {
                for (int i = 0; i < sti.length; ++i) {
                    this.element("SemanticTypeIdentifier", sti[i]);
                }
            }
            Rule[] rules = fts.getRules();
            for (int i = 0; i < rules.length; ++i) {
                rules[i].accept(this);
            }
            this.end("FeatureTypeStyle");
        }

        @Override
        public void visit(Displacement dis) {
            if (dis == null) {
                return;
            }
            Expression dx = dis.getDisplacementX();
            Expression dy = dis.getDisplacementY();
            if (this.isNull(dx) && this.isNull(dy)) {
                return;
            }
            if (this.isDefault(dx, 0) && this.isDefault(dy, 0)) {
                return;
            }
            this.start("Displacement");
            this.element("DisplacementX", dis.getDisplacementX());
            this.element("DisplacementY", dis.getDisplacementY());
            this.end("Displacement");
        }

        void encodeGeometryProperty(String name) {
            if (name == null || name.trim().length() == 0) {
                return;
            }
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            PropertyName expression = ff.property(name);
            this.start("Geometry");
            this.filterTranslator.encode(expression);
            this.end("Geometry");
        }

        void encodeGeometryExpression(Expression geom) {
            if (geom == null) {
                return;
            }
            this.start("Geometry");
            this.filterTranslator.encode(geom);
            this.end("Geometry");
        }

        void encodeCssParam(String name, Expression expression) {
            this.encodeCssParam(name, expression, null);
        }

        void encodeCssParam(String name, Expression expression, Object defaultValue) {
            if (expression == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name);
            this.encodeValue("CssParameter", atts, expression, defaultValue);
        }

        void encodeValue(String elementName, Attributes atts, Expression expression, Object defaultValue) {
            Object value;
            if (expression == null) {
                return;
            }
            if (expression instanceof Literal && defaultValue != null && (value = expression.evaluate(null, defaultValue.getClass())) != null && value.equals(defaultValue)) {
                return;
            }
            if (atts == null) {
                atts = this.NULL_ATTS;
            }
            if (expression instanceof Literal) {
                this.element(elementName, expression.evaluate(null, String.class), atts);
            } else {
                this.start(elementName, atts);
                this.filterTranslator.encode(expression);
                this.end(elementName);
            }
        }

        void encodeVendorOptions(Map options) {
            if (options != null) {
                for (String key : options.keySet()) {
                    String value = (String)options.get(key);
                    this.encodeVendorOption(key, value);
                }
            }
        }

        void encodeVendorOption(String key, String value) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", key);
            this.start("VendorOption", atts);
            this.chars(value);
            this.end("VendorOption");
        }

        public void encode(Style[] styles) {
            try {
                this.contentHandler.startDocument();
                this.start("StyledLayerDescriptor", this.NULL_ATTS);
                this.start("NamedLayer", this.NULL_ATTS);
                int ii = styles.length;
                for (int i = 0; i < ii; ++i) {
                    styles[i].accept(this);
                }
                this.end("NamedLayer");
                this.end("StyledLayerDescriptor");
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void encode(StyledLayerDescriptor sld) {
            try {
                this.contentHandler.startDocument();
                sld.accept(this);
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            if (o instanceof StyledLayerDescriptor) {
                this.encode((StyledLayerDescriptor)o);
            } else if (o instanceof Style[]) {
                this.encode((Style[])o);
            } else {
                Class<?> c = o.getClass();
                try {
                    Method m = c.getMethod("accept", StyleVisitor.class);
                    m.invoke(o, this);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalArgumentException("Cannot encode " + o);
                }
                catch (Exception e) {
                    throw new RuntimeException("Internal transformation exception", e);
                }
            }
        }

        @Override
        public void visit(ContrastEnhancement ce) {
            Literal exp;
            if (ce == null || ce.getMethod() == null) {
                return;
            }
            this.start("ContrastEnhancement");
            ContrastMethod method = ce.getMethod();
            if (method != null && !ContrastMethod.NONE.equals(method)) {
                String val = method.name();
                val = val.substring(0, 1).toUpperCase() + val.substring(1).toLowerCase();
                this.start(val);
                this.end(val);
            }
            if ((exp = (Literal)ce.getGammaValue()) != null) {
                this.element("GammaValue", exp.getValue().toString());
            }
            this.end("ContrastEnhancement");
        }

        @Override
        public void visit(ImageOutline outline) {
            if (outline == null) {
                return;
            }
            this.start("ImageOutline");
            outline.getSymbolizer().accept(this);
            this.end("ImageOutline");
        }

        @Override
        public void visit(ChannelSelection cs) {
            if (cs == null) {
                return;
            }
            this.start("ChannelSelection");
            SelectedChannelType[] sct = cs.getSelectedChannels();
            for (int i = 0; i < sct.length && sct != null; ++i) {
                this.visit(sct[i]);
            }
            this.end("ChannelSelection");
        }

        @Override
        public void visit(OverlapBehavior ob) {
            this.start("OverlapBehavior");
            String pn = (String)ob.getValue();
            this.start(pn);
            this.end(pn);
            this.end("OverlapBehavior");
        }

        @Override
        public void visit(SelectedChannelType sct) {
            this.element("SourceChannelName", sct.getChannelName());
            ContrastEnhancement ce = sct.getContrastEnhancement();
            if (ce != null) {
                ce.accept(this);
            }
        }

        @Override
        public void visit(ShadedRelief sr) {
            this.start("ShadedRelief");
            if (sr.isBrightnessOnly()) {
                this.element("BrightnessOnly", "true");
            } else {
                this.element("BrightnessOnly", "false");
            }
            if (sr.getReliefFactor() != null) {
                Literal l = (Literal)sr.getReliefFactor();
                this.element("ReliefFactor", l.getValue().toString());
            }
            this.end("ShadedRelief");
        }
    }
}

