/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.FontBlock;
import org.mapfish.print.scalebar.Direction;
import org.mapfish.print.scalebar.Label;
import org.mapfish.print.scalebar.ScalebarDrawer;
import org.mapfish.print.scalebar.Type;
import org.mapfish.print.utils.DistanceUnit;
import org.mapfish.print.utils.PJsonObject;

public class ScalebarBlock
extends FontBlock {
    private int maxSize = 150;
    private Type type = Type.LINE;
    private int intervals = 3;
    private boolean subIntervals = false;
    private DistanceUnit units = null;
    private boolean lockUnits = false;
    private Integer barSize = null;
    private Direction barDirection = Direction.UP;
    private Direction textDirection = Direction.UP;
    private Integer labelDistance = null;
    private String color = "black";
    private String barBgColor = null;
    private Double lineWidth = null;

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        PJsonObject globalParams = context.getGlobalParams();
        DistanceUnit mapUnits = DistanceUnit.fromString(globalParams.getString("units"));
        if (mapUnits == null) {
            throw new InvalidJsonValueException(globalParams, "units", globalParams.getString("units"));
        }
        DistanceUnit scaleUnit = this.units != null ? this.units : mapUnits;
        double scale = context.getLayout().getMainPage().getMap().createTransformer(context, params).getScale();
        double maxWidthIntervaleDistance = DistanceUnit.PT.convertTo(this.maxSize, scaleUnit) * scale / (double)this.intervals;
        double intervalDistance = this.getNearestNiceValue(maxWidthIntervaleDistance, scaleUnit);
        Font pdfFont = this.getPdfFont();
        this.tryLayout(context, target, pdfFont, scaleUnit, scale, intervalDistance, 0);
    }

    private void tryLayout(RenderingContext context, Block.PdfElement target, Font pdfFont, DistanceUnit scaleUnit, double scale, double intervalDistance, int tryNumber) throws DocumentException {
        float rightLabelMargin;
        float leftLabelMargin;
        if (tryNumber > 3) {
            context.addError(new InvalidValueException("maxSize too small", this.maxSize));
            return;
        }
        DistanceUnit intervalUnit = this.bestUnit(scaleUnit, intervalDistance);
        float intervalPaperWidth = (float)scaleUnit.convertTo(intervalDistance / scale, DistanceUnit.PT);
        ArrayList<Label> labels = new ArrayList<Label>(this.intervals + 1);
        BaseFont baseFont = pdfFont.getCalculatedBaseFont(false);
        if (this.intervals > 1 || this.subIntervals) {
            for (int i = 0; i <= this.intervals; ++i) {
                String labelText = this.createLabelText(scaleUnit, intervalDistance * (double)i, intervalUnit);
                if (i == this.intervals) {
                    labelText = labelText + (Object)((Object)intervalUnit);
                }
                labels.add(new Label(intervalPaperWidth * (float)i, labelText, baseFont, this.getFontSize(), !this.barDirection.isSameOrientation(this.textDirection)));
            }
            leftLabelMargin = ((Label)labels.get((int)0)).width / 2.0f;
            rightLabelMargin = ((Label)labels.get((int)(labels.size() - 1))).width / 2.0f;
        } else {
            Label label = new Label(intervalPaperWidth / 2.0f, this.createLabelText(scaleUnit, intervalDistance, intervalUnit) + (Object)((Object)intervalUnit), baseFont, this.getFontSize(), !this.barDirection.isSameOrientation(this.textDirection));
            labels.add(label);
            leftLabelMargin = rightLabelMargin = Math.max(0.0f, label.width - intervalPaperWidth) / 2.0f;
        }
        if ((float)this.intervals * intervalPaperWidth + leftLabelMargin + rightLabelMargin <= (float)this.maxSize) {
            this.doLayout(context, target, pdfFont, labels, intervalPaperWidth, scaleUnit, intervalDistance, intervalUnit, leftLabelMargin, rightLabelMargin);
        } else {
            double nextIntervalDistance = this.getNearestNiceValue(intervalDistance * 0.9, scaleUnit);
            this.tryLayout(context, target, pdfFont, scaleUnit, scale, nextIntervalDistance, tryNumber + 1);
        }
    }

    private DistanceUnit bestUnit(DistanceUnit scaleUnit, double intervalDistance) {
        if (this.lockUnits) {
            return scaleUnit;
        }
        return DistanceUnit.getBestUnit(intervalDistance, scaleUnit);
    }

    private void doLayout(RenderingContext context, Block.PdfElement target, Font pdfFont, List<Label> labels, float intervalWidth, DistanceUnit scaleUnit, double intervalDistance, DistanceUnit intervalUnit, float leftLabelPaperMargin, float rightLabelPaperMargin) throws DocumentException {
        float height;
        float width;
        float maxLabelHeight = 0.0f;
        float maxLabelWidth = 0.0f;
        for (int i = 0; i < labels.size(); ++i) {
            Label label = labels.get(i);
            maxLabelHeight = Math.max(maxLabelHeight, label.height);
            maxLabelWidth = Math.max(maxLabelWidth, label.width);
        }
        float straightWidth = intervalWidth * (float)this.intervals + leftLabelPaperMargin + rightLabelPaperMargin;
        float straightHeight = (float)(this.getBarSize() + this.getLabelDistance()) + maxLabelHeight;
        if (this.barDirection == Direction.DOWN || this.barDirection == Direction.UP) {
            width = straightWidth;
            height = straightHeight;
        } else {
            width = straightHeight;
            height = straightWidth;
        }
        int numSubIntervals = 1;
        if (this.subIntervals) {
            numSubIntervals = this.getNbSubIntervals(scaleUnit, intervalDistance, intervalUnit);
        }
        ScalebarDrawer drawer = ScalebarDrawer.create(context.getCustomBlocks(), this, this.type, labels, this.getBarSize(), this.getLabelDistance(), numSubIntervals, intervalWidth, pdfFont, leftLabelPaperMargin, rightLabelPaperMargin, maxLabelWidth, maxLabelHeight);
        target.add(PDFUtils.createPlaceholderTable(width, height, this.spacingAfter, drawer, this.align, context.getCustomBlocks()));
    }

    private String createLabelText(DistanceUnit scaleUnit, double value, DistanceUnit intervalUnit) {
        double scaledValue = scaleUnit.convertTo(value, intervalUnit);
        String decimals = Double.toString(scaledValue = (double)(Math.round(scaledValue * 10000.0) / 10000L)).split("\\.")[1];
        if (Double.valueOf(decimals) == 0.0) {
            return Long.toString(Math.round(scaledValue));
        }
        return Double.toString(scaledValue);
    }

    private double getNearestNiceValue(double value, DistanceUnit scaleUnit) {
        int digits;
        double pow10;
        DistanceUnit bestUnit = this.bestUnit(scaleUnit, value);
        double factor = scaleUnit.convertTo(1.0, bestUnit);
        double firstChar = value * factor / (pow10 = Math.pow(10.0, digits = (int)Math.floor(Math.log(value * factor) / Math.log(10.0))));
        int barLen = firstChar >= 10.0 ? 10 : (firstChar >= 5.0 ? 5 : (firstChar >= 2.0 ? 2 : 1));
        return (double)barLen * pow10 / factor;
    }

    private int getNbSubIntervals(DistanceUnit scaleUnit, double intervalDistance, DistanceUnit intervalUnit) {
        double value = scaleUnit.convertTo(intervalDistance, intervalUnit);
        int digits = (int)(Math.log(value) / Math.log(10.0));
        double pow10 = Math.pow(10.0, digits);
        int firstChar = (int)(value / pow10);
        switch (firstChar) {
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 5;
            }
            case 10: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid interval: " + value + (Object)((Object)intervalUnit) + " (" + firstChar + ")");
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        if (maxSize <= 0) {
            throw new InvalidValueException("maxSize", maxSize);
        }
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setIntervals(int intervals) {
        if (intervals < 1) {
            throw new InvalidValueException("intervals", intervals);
        }
        this.intervals = intervals;
    }

    public void setSubIntervals(boolean subIntervals) {
        this.subIntervals = subIntervals;
    }

    public void setUnits(DistanceUnit units) {
        this.units = units;
    }

    public void setLockUnits(boolean lock) {
        this.lockUnits = lock;
    }

    public void setBarSize(int barSize) {
        this.barSize = barSize;
        if (barSize < 0) {
            throw new InvalidValueException("barSize", barSize);
        }
    }

    public void setBarDirection(Direction barDirection) {
        this.barDirection = barDirection;
    }

    public void setTextDirection(Direction textDirection) {
        this.textDirection = textDirection;
    }

    public void setLabelDistance(int labelDistance) {
        this.labelDistance = labelDistance;
    }

    public void setBarBgColor(String barBgColor) {
        this.barBgColor = barBgColor;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        if (lineWidth < 0.0) {
            throw new InvalidValueException("lineWidth", lineWidth);
        }
    }

    public int getBarSize() {
        if (this.barSize != null) {
            return this.barSize;
        }
        return this.maxSize / 30;
    }

    public int getLabelDistance() {
        if (this.labelDistance != null) {
            return this.labelDistance;
        }
        return this.maxSize / 40;
    }

    @Override
    public double getFontSize() {
        if (this.fontSize != null) {
            return this.fontSize;
        }
        return (double)this.maxSize * 10.0 / 200.0;
    }

    public double getLineWidth() {
        if (this.lineWidth != null) {
            return this.lineWidth;
        }
        return (double)this.maxSize / 150.0;
    }

    public Direction getBarDirection() {
        return this.barDirection;
    }

    public Direction getTextDirection() {
        return this.textDirection;
    }

    public int getIntervals() {
        return this.intervals;
    }

    public Color getBarBgColorVal() {
        return ColorWrapper.convertColor(this.barBgColor);
    }

    public Color getColorVal() {
        return ColorWrapper.convertColor(this.color);
    }
}

