/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.mapfish.print.MapPrinter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class BaseMapServlet
extends HttpServlet {
    private static final long serialVersionUID = -6342262849725708850L;
    public static final Logger LOGGER = Logger.getLogger(BaseMapServlet.class);
    private Map<String, MapPrinter> printers = null;
    private long lastModified = 0L;
    private long defaultLastModified = 0L;
    private Map<String, Long> lastModifieds = null;
    private volatile ApplicationContext context;

    protected synchronized MapPrinter getMapPrinter(String app) throws ServletException {
        String configPath = this.getInitParameter("config");
        if (configPath == null) {
            throw new ServletException("Missing configuration in web.xml 'web-app/servlet/init-param[param-name=config]' or 'web-app/context-param[param-name=config]'");
        }
        MapPrinter printer = null;
        File configFile = null;
        if (app != null) {
            if (this.lastModifieds == null) {
                this.lastModifieds = new HashMap<String, Long>();
            }
            printer = this.printers instanceof HashMap && this.printers.containsKey(app) ? this.printers.get(app) : null;
            configFile = new File(app);
        } else {
            configFile = new File(configPath);
        }
        if (!configFile.isAbsolute()) {
            configFile = app != null ? (app.toLowerCase().endsWith(".yaml") ? new File(this.getServletContext().getRealPath(app)) : new File(this.getServletContext().getRealPath(app + ".yaml"))) : (configPath.toLowerCase().endsWith(".yaml") ? new File(this.getServletContext().getRealPath(configPath)) : new File(this.getServletContext().getRealPath(configPath + ".yaml")));
        }
        this.lastModified = app != null ? (this.lastModifieds instanceof HashMap && this.lastModifieds.containsKey(app) ? this.lastModifieds.get(app) : 0L) : this.defaultLastModified;
        boolean forceReload = false;
        if (printer != null && printer.getConfig().getReloadConfig()) {
            forceReload = true;
        }
        if (forceReload || printer != null && configFile.lastModified() != this.lastModified) {
            if (!forceReload) {
                LOGGER.info("Configuration file modified. Reloading...");
            }
            try {
                printer.stop();
            }
            catch (NullPointerException npe) {
                LOGGER.info("BaseMapServlet.java: printer was not stopped. This happens when a switch between applications happens.\n" + npe);
            }
            printer = null;
            if (app != null) {
                LOGGER.info("Printer for " + app + " stopped");
                this.printers.put(app, null);
            }
        }
        if (printer == null) {
            this.lastModified = configFile.lastModified();
            try {
                LOGGER.info("Loading configuration file: " + configFile.getAbsolutePath());
                printer = this.getApplicationContext().getBean(MapPrinter.class).setYamlConfigFile(configFile);
                if (app != null) {
                    if (this.printers == null) {
                        this.printers = new HashMap<String, MapPrinter>();
                    }
                    this.printers.put(app, printer);
                    this.lastModifieds.put(app, this.lastModified);
                } else {
                    this.defaultLastModified = this.lastModified;
                }
            }
            catch (FileNotFoundException e) {
                throw new ServletException("Cannot read configuration file: " + configPath, (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Error occurred while reading configuration file", e);
                throw new ServletException("Error occurred while reading configuration file '" + configFile + "': " + e);
            }
        }
        return printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationContext getApplicationContext() {
        if (this.context == null) {
            BaseMapServlet baseMapServlet = this;
            synchronized (baseMapServlet) {
                if (this.context == null) {
                    this.context = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
                    if (this.context == null || this.context.getBean(MapPrinter.class) == null) {
                        String springConfig = System.getProperty("mapfish.print.springConfig");
                        this.context = springConfig != null ? new FileSystemXmlApplicationContext("classpath:/mapfish-spring-application-context.xml", springConfig) : new ClassPathXmlApplicationContext("mapfish-spring-application-context.xml");
                    }
                }
            }
        }
        return this.context;
    }
}

