/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import org.springframework.instrument.classloading.jboss.JBossMCAdapter;
import org.springframework.instrument.classloading.jboss.JBossModulesAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JBossLoadTimeWeaver
implements LoadTimeWeaver {
    private final JBossClassLoaderAdapter adapter;

    public JBossLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public JBossLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        String loaderClassName = classLoader.getClass().getName();
        if (loaderClassName.startsWith("org.jboss.classloader")) {
            this.adapter = new JBossMCAdapter(classLoader);
        } else if (loaderClassName.startsWith("org.jboss.modules")) {
            this.adapter = new JBossModulesAdapter(classLoader);
        } else {
            throw new IllegalArgumentException("Unexpected ClassLoader type: " + loaderClassName);
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.adapter.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.adapter.getInstrumentableClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

