/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.referencing.CRS;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultCRSFilterVisitor
extends DuplicatingFilterVisitor {
    private CoordinateReferenceSystem defaultCrs;

    public DefaultCRSFilterVisitor(FilterFactory2 factory, CoordinateReferenceSystem defaultCrs) {
        super(factory);
        this.defaultCrs = defaultCrs;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        String srs = filter.getSRS();
        if (srs != null && !"".equals(srs.trim())) {
            return super.visit(filter, extraData);
        }
        try {
            double minx = filter.getMinX();
            double miny = filter.getMinY();
            double maxx = filter.getMaxX();
            double maxy = filter.getMaxY();
            String propertyName = filter.getPropertyName();
            String defaultSrs = CRS.toSRS(this.defaultCrs);
            return this.getFactory(extraData).bbox(propertyName, minx, miny, maxx, maxy, defaultSrs);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode srs '" + srs + "'", e);
        }
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        if (!(expression.getValue() instanceof Geometry)) {
            return super.visit(expression, extraData);
        }
        Geometry geom = (Geometry)expression.getValue();
        if (geom.getUserData() != null && geom.getUserData() instanceof CoordinateReferenceSystem) {
            return super.visit(expression, extraData);
        }
        Geometry clone = geom.getFactory().createGeometry(geom);
        clone.setUserData(this.defaultCrs);
        return this.ff.literal(clone);
    }
}

