/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.itextpdf.text.DocumentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.FileUtilities;

public class MapPrinterServlet
extends BaseMapServlet {
    public static final Logger SPEC_LOGGER = Logger.getLogger(BaseMapServlet.class.getPackage().toString() + ".spec");
    private static final long serialVersionUID = -4706371598927161642L;
    private static final String CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private static final String INFO_URL = "/info.json";
    private static final String PRINT_URL = "/print.pdf";
    private static final String CREATE_URL = "/create.json";
    protected static final String TEMP_FILE_PREFIX = "mapfish-print";
    private static final String TEMP_FILE_SUFFIX = ".printout";
    private String app = null;
    private static final int TEMP_FILE_PURGE_SECONDS = 600;
    private File tempDir = null;
    private String encoding = null;
    private AtomicBoolean purging = new AtomicBoolean(false);
    private final Map<String, TempFile> tempFiles = new HashMap<String, TempFile>();

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String additionalPath = httpServletRequest.getPathInfo().trim();
        if (additionalPath.isEmpty()) {
            additionalPath = httpServletRequest.getServletPath();
        }
        if (additionalPath.equals(PRINT_URL)) {
            this.createAndGetPDF(httpServletRequest, httpServletResponse);
        } else if (additionalPath.equals(INFO_URL)) {
            this.getInfo(httpServletRequest, httpServletResponse, this.getBaseUrl(httpServletRequest));
        } else if (additionalPath.startsWith("/") && additionalPath.endsWith(TEMP_FILE_SUFFIX)) {
            this.getFile(httpServletRequest, httpServletResponse, additionalPath.substring(1, additionalPath.length() - TEMP_FILE_SUFFIX.length()));
        } else {
            this.error(httpServletResponse, "Unknown method: " + additionalPath, 404);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String additionalPath = httpServletRequest.getPathInfo();
        if (additionalPath.equals(PRINT_URL)) {
            this.createAndGetPDF(httpServletRequest, httpServletResponse);
        } else if (additionalPath.equals(CREATE_URL)) {
            this.createPDF(httpServletRequest, httpServletResponse, this.getBaseUrl(httpServletRequest));
        } else {
            this.error(httpServletResponse, "Unknown method: " + additionalPath, 404);
        }
    }

    public void init() throws ServletException {
        File[] files;
        File dir = this.getTempDir();
        for (File file : files = dir.listFiles()) {
            this.deleteFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, TempFile> map = this.tempFiles;
        synchronized (map) {
            for (File file : this.tempFiles.values()) {
                this.deleteFile(file);
            }
            this.tempFiles.clear();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAndGetPDF(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        TempFile tempFile = null;
        String spec = null;
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (httpServletRequest.getMethod() == "POST") {
            try {
                spec = this.getSpecFromPostBody(httpServletRequest);
            }
            catch (IOException e) {
                this.error(httpServletResponse, "Missing 'spec' in request body", 500);
                return;
            }
        } else {
            spec = httpServletRequest.getParameter("spec");
        }
        if (spec == null) {
            this.error(httpServletResponse, "Missing 'spec' parameter", 500);
            return;
        }
        try {
            tempFile = this.doCreatePDFFile(spec, httpServletRequest);
            this.sendPdfFile(httpServletResponse, tempFile, Boolean.parseBoolean(httpServletRequest.getParameter("inline")));
        }
        catch (Throwable e) {
            this.error(httpServletResponse, e);
        }
        finally {
            this.deleteFile(tempFile);
        }
    }

    protected void createPDF(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String basePath) throws ServletException {
        TempFile tempFile = null;
        try {
            this.purgeOldTemporaryFiles();
            String spec = this.getSpecFromPostBody(httpServletRequest);
            tempFile = this.doCreatePDFFile(spec, httpServletRequest);
            if (tempFile == null) {
                this.error(httpServletResponse, "Missing 'spec' parameter", 500);
                return;
            }
        }
        catch (Throwable e) {
            this.deleteFile(tempFile);
            this.error(httpServletResponse, e);
            return;
        }
        String id = this.generateId(tempFile);
        httpServletResponse.setContentType("application/json; charset=utf-8");
        PrintWriter writer = null;
        try {
            writer = httpServletResponse.getWriter();
            JSONWriter json = new JSONWriter(writer);
            json.object();
            json.key("getURL").value(basePath + "/" + id + TEMP_FILE_SUFFIX);
            json.endObject();
        }
        catch (JSONException e) {
            this.deleteFile(tempFile);
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            this.deleteFile(tempFile);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        this.addTempFile(tempFile, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempFile(TempFile tempFile, String id) {
        Map<String, TempFile> map = this.tempFiles;
        synchronized (map) {
            this.tempFiles.put(id, tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSpecFromPostBody(HttpServletRequest httpServletRequest) throws IOException {
        if (httpServletRequest.getParameter("spec") != null) {
            return httpServletRequest.getParameter("spec");
        }
        Closer closer = Closer.create();
        try {
            String spec;
            InputStreamReader reader = closer.register(new InputStreamReader((InputStream)httpServletRequest.getInputStream(), this.getEncoding()));
            BufferedReader bufferedReader = closer.register(new BufferedReader(reader));
            String string = spec = CharStreams.toString(bufferedReader);
            return string;
        }
        finally {
            closer.close();
        }
    }

    protected String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.getInitParameter("encoding");
            LOGGER.debug("Using '" + this.encoding + "' to encode Inputcontent.");
        }
        if (this.encoding == null) {
            return "UTF-8";
        }
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getFile(HttpServletRequest req, HttpServletResponse httpServletResponse, String id) throws IOException, ServletException {
        TempFile file;
        Map<String, TempFile> map = this.tempFiles;
        synchronized (map) {
            file = this.tempFiles.get(id);
        }
        if (file == null) {
            this.error(httpServletResponse, "File with id=" + id + " unknown", 404);
            return;
        }
        this.sendPdfFile(httpServletResponse, file, Boolean.parseBoolean(req.getParameter("inline")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getInfo(HttpServletRequest req, HttpServletResponse resp, String basePath) throws ServletException, IOException {
        this.app = req.getParameter("app");
        MapPrinter printer = this.getMapPrinter(this.app);
        resp.setContentType("application/json; charset=utf-8");
        PrintWriter writer = resp.getWriter();
        try {
            String var = req.getParameter("var");
            if (var != null) {
                writer.print(var + "=");
            }
            JSONWriter json = new JSONWriter(writer);
            try {
                json.object();
                printer.printClientConfig(json);
                String urlToUseInSpec = basePath;
                String proxyUrl = printer.getConfig().getProxyBaseUrl();
                if (proxyUrl != null) {
                    urlToUseInSpec = proxyUrl;
                }
                json.key("printURL").value(urlToUseInSpec + PRINT_URL);
                json.key("createURL").value(urlToUseInSpec + CREATE_URL);
                if (this.app != null) {
                    json.key("app").value(this.app);
                }
                json.endObject();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            if (var != null) {
                writer.print(";");
            }
        }
        finally {
            writer.close();
            if (this.app == null && printer != null) {
                printer.stop();
            }
        }
    }

    protected TempFile doCreatePDFFile(String spec, HttpServletRequest httpServletRequest) throws IOException, DocumentException, ServletException, InterruptedException {
        PJsonObject specJson;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Generating PDF for spec=" + spec);
        }
        if (SPEC_LOGGER.isInfoEnabled()) {
            SPEC_LOGGER.info(spec);
        }
        this.app = (specJson = MapPrinter.parseSpec(spec)).has("app") ? specJson.getString("app") : null;
        MapPrinter mapPrinter = this.getMapPrinter(this.app);
        HashMap<String, String> headers = new HashMap<String, String>();
        TreeSet<String> configHeaders = mapPrinter.getConfig().getHeaders();
        if (configHeaders == null) {
            configHeaders = new TreeSet();
            configHeaders.add("Referer");
            configHeaders.add("Cookie");
        }
        for (String header : configHeaders) {
            if (httpServletRequest.getHeader(header) == null) continue;
            headers.put(header, httpServletRequest.getHeader(header));
        }
        OutputFormat outputFormat = mapPrinter.getOutputFormat(specJson);
        File tempJavaFile = File.createTempFile(TEMP_FILE_PREFIX, "." + outputFormat.getFileSuffix() + TEMP_FILE_SUFFIX, this.getTempDir());
        TempFile tempFile = new TempFile(tempJavaFile, specJson, outputFormat);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
            mapPrinter.print(specJson, out, headers);
            TempFile tempFile2 = tempFile;
            return tempFile2;
        }
        catch (IOException e) {
            this.deleteFile(tempFile);
            throw e;
        }
        catch (DocumentException e) {
            this.deleteFile(tempFile);
            throw e;
        }
        catch (InterruptedException e) {
            this.deleteFile(tempFile);
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPdfFile(HttpServletResponse httpServletResponse, TempFile tempFile, boolean inline) throws IOException, ServletException {
        FileInputStream pdf = new FileInputStream(tempFile);
        ServletOutputStream response = httpServletResponse.getOutputStream();
        MapPrinter mapPrinter = this.getMapPrinter(this.app);
        try {
            httpServletResponse.setContentType(tempFile.contentType());
            if (!inline) {
                String fileName = tempFile.getOutputFileName(mapPrinter);
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + fileName);
            }
            FileUtilities.copyStream(pdf, (OutputStream)response);
        }
        finally {
            try {
                pdf.close();
            }
            finally {
                response.close();
            }
            if (this.app == null && mapPrinter != null) {
                mapPrinter.stop();
            }
        }
    }

    protected void error(HttpServletResponse httpServletResponse, Throwable e) {
        PrintWriter out = null;
        try {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(500);
            out = httpServletResponse.getWriter();
            out.println("Error while generating PDF:");
            e.printStackTrace(out);
            LOGGER.error("Error while generating PDF", e);
        }
        catch (IOException ex) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void error(HttpServletResponse httpServletResponse, String message, int code) {
        PrintWriter out = null;
        try {
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(code);
            out = httpServletResponse.getWriter();
            out.println("Error while generating PDF:");
            out.println(message);
            LOGGER.error("Error while generating PDF: " + message);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected File getTempDir() {
        if (this.tempDir == null) {
            String tempDirPath = this.getInitParameter("tempdir");
            this.tempDir = tempDirPath != null ? new File(tempDirPath) : (File)this.getServletContext().getAttribute(CONTEXT_TEMPDIR);
            if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
                throw new RuntimeException("unable to create dir:" + this.tempDir);
            }
        }
        LOGGER.debug("Using '" + this.tempDir.getAbsolutePath() + "' as temporary directory");
        return this.tempDir;
    }

    protected void deleteFile(File file) {
        if (file != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting PDF file: " + file.getName());
            }
            if (!file.delete()) {
                LOGGER.warn("Cannot delete file:" + file.getAbsolutePath());
            }
        }
    }

    protected String generateId(File tempFile) {
        String name = tempFile.getName();
        return name.substring(TEMP_FILE_PREFIX.length(), name.length() - TEMP_FILE_SUFFIX.length());
    }

    protected String getBaseUrl(HttpServletRequest httpServletRequest) {
        String additionalPath = httpServletRequest.getPathInfo();
        String fullUrl = httpServletRequest.getParameter("url");
        if (fullUrl != null) {
            return fullUrl.replaceFirst(additionalPath + "$", "");
        }
        return httpServletRequest.getRequestURL().toString().replaceFirst(additionalPath + "$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeOldTemporaryFiles() {
        if (!this.purging.getAndSet(true)) {
            long minTime = System.currentTimeMillis() - 600000L;
            Map<String, TempFile> map = this.tempFiles;
            synchronized (map) {
                Iterator<Map.Entry<String, TempFile>> it = this.tempFiles.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, TempFile> entry = it.next();
                    if (entry.getValue().creationTime >= minTime) continue;
                    this.deleteFile(entry.getValue());
                    it.remove();
                }
            }
            this.purging.set(false);
        }
    }

    static class TempFile
    extends File {
        private static final long serialVersionUID = 455104129549002361L;
        private final long creationTime = System.currentTimeMillis();
        public final String printedLayoutName;
        public final String outputFileName;
        private final String contentType;
        private String suffix;

        public TempFile(File tempFile, PJsonObject jsonSpec, OutputFormat format) {
            super(tempFile.getAbsolutePath());
            this.outputFileName = jsonSpec.optString("outputFilename");
            this.printedLayoutName = jsonSpec.optString("layout", null);
            this.suffix = format.getFileSuffix();
            this.contentType = format.getContentType();
        }

        public String getOutputFileName(MapPrinter mapPrinter) {
            if (this.outputFileName != null) {
                return TempFile.formatFileName(this.suffix, this.outputFileName, new Date());
            }
            return TempFile.formatFileName(this.suffix, mapPrinter.getOutputFilename(this.printedLayoutName, this.getName()), new Date());
        }

        public static String formatFileName(String suffix, String startingName, Date date) {
            Matcher matcher = Pattern.compile("\\$\\{(.+?)\\}").matcher(startingName);
            HashMap<String, String> replacements = new HashMap<String, String>();
            while (matcher.find()) {
                String pattern = matcher.group(1);
                String key = "${" + pattern + "}";
                replacements.put(key, TempFile.findReplacement(pattern, date));
            }
            String result = startingName;
            for (Map.Entry entry : replacements.entrySet()) {
                result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            while (suffix.startsWith(".")) {
                suffix = suffix.substring(1);
            }
            if (suffix.isEmpty() || result.toLowerCase().endsWith("." + suffix.toLowerCase())) {
                return result;
            }
            return result + "." + suffix;
        }

        public static String cleanUpName(String original) {
            return original.replace(",", "").replaceAll("\\s+", "_");
        }

        private static String findReplacement(String pattern, Date date) {
            if (pattern.toLowerCase().equals("date")) {
                return TempFile.cleanUpName(DateFormat.getDateInstance().format(date));
            }
            if (pattern.toLowerCase().equals("datetime")) {
                return TempFile.cleanUpName(DateFormat.getDateTimeInstance().format(date));
            }
            if (pattern.toLowerCase().equals("time")) {
                return TempFile.cleanUpName(DateFormat.getTimeInstance().format(date));
            }
            try {
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception e) {
                BaseMapServlet.LOGGER.error("Unable to format timestamp according to pattern: " + pattern, e);
                return "${" + pattern + "}";
            }
        }

        public String contentType() {
            return this.contentType;
        }
    }
}

