/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutablePropertySources
implements PropertySources {
    static final String NON_EXISTENT_PROPERTY_SOURCE_MESSAGE = "PropertySource named [%s] does not exist";
    static final String ILLEGAL_RELATIVE_ADDITION_MESSAGE = "PropertySource named [%s] cannot be added relative to itself";
    private final Log logger;
    private final LinkedList<PropertySource<?>> propertySourceList = new LinkedList();

    public MutablePropertySources() {
        this.logger = LogFactory.getLog(this.getClass());
    }

    public MutablePropertySources(PropertySources propertySources) {
        this();
        for (PropertySource propertySource : propertySources) {
            this.addLast(propertySource);
        }
    }

    MutablePropertySources(Log logger) {
        this.logger = logger;
    }

    @Override
    public boolean contains(String name) {
        return this.propertySourceList.contains(PropertySource.named(name));
    }

    @Override
    public PropertySource<?> get(String name) {
        return this.propertySourceList.get(this.propertySourceList.indexOf(PropertySource.named(name)));
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    public void addFirst(PropertySource<?> propertySource) {
        this.logger.debug(String.format("Adding [%s] PropertySource with highest search precedence", propertySource.getName()));
        this.removeIfPresent(propertySource);
        this.propertySourceList.addFirst(propertySource);
    }

    public void addLast(PropertySource<?> propertySource) {
        this.logger.debug(String.format("Adding [%s] PropertySource with lowest search precedence", propertySource.getName()));
        this.removeIfPresent(propertySource);
        this.propertySourceList.addLast(propertySource);
    }

    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.logger.debug(String.format("Adding [%s] PropertySource with search precedence immediately higher than [%s]", propertySource.getName(), relativePropertySourceName));
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        this.removeIfPresent(propertySource);
        int index = this.assertPresentAndGetIndex(relativePropertySourceName);
        this.addAtIndex(index, propertySource);
    }

    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.logger.debug(String.format("Adding [%s] PropertySource with search precedence immediately lower than [%s]", propertySource.getName(), relativePropertySourceName));
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        this.removeIfPresent(propertySource);
        int index = this.assertPresentAndGetIndex(relativePropertySourceName);
        this.addAtIndex(index + 1, propertySource);
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        return this.propertySourceList.indexOf(propertySource);
    }

    public PropertySource<?> remove(String name) {
        this.logger.debug(String.format("Removing [%s] PropertySource", name));
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        if (index >= 0) {
            return this.propertySourceList.remove(index);
        }
        return null;
    }

    public void replace(String name, PropertySource<?> propertySource) {
        this.logger.debug(String.format("Replacing [%s] PropertySource with [%s]", name, propertySource.getName()));
        int index = this.assertPresentAndGetIndex(name);
        this.propertySourceList.set(index, propertySource);
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public synchronized String toString() {
        Object[] names = new String[this.size()];
        int i = 0;
        while (i < this.size()) {
            names[i] = this.propertySourceList.get(i).getName();
            ++i;
        }
        return String.format("[%s]", StringUtils.arrayToCommaDelimitedString(names));
    }

    protected void assertLegalRelativeAddition(String relativePropertySourceName, PropertySource<?> propertySource) {
        String newPropertySourceName = propertySource.getName();
        Assert.isTrue(!relativePropertySourceName.equals(newPropertySourceName), String.format(ILLEGAL_RELATIVE_ADDITION_MESSAGE, newPropertySourceName));
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        if (this.propertySourceList.contains(propertySource)) {
            this.propertySourceList.remove(propertySource);
        }
    }

    private void addAtIndex(int index, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(index, propertySource);
    }

    private int assertPresentAndGetIndex(String propertySourceName) {
        int index = this.propertySourceList.indexOf(PropertySource.named(propertySourceName));
        Assert.isTrue(index >= 0, String.format(NON_EXISTENT_PROPERTY_SOURCE_MESSAGE, propertySourceName));
        return index;
    }
}

