/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.piecewise.DefaultConstantPiecewiseTransformElement;
import org.geotools.referencing.piecewise.DefaultDomain1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseTransform1D;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.renderer.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class DefaultPiecewiseTransform1D<T extends DefaultPiecewiseTransform1DElement>
extends DefaultDomain1D<T>
implements PiecewiseTransform1D<T> {
    private boolean hasDefaultValue;
    private double defaultValue;
    private int hashCode = -1;

    public DefaultPiecewiseTransform1D(T[] domainElements, double defaultValue) {
        super(domainElements);
        this.hasDefaultValue = true;
        this.defaultValue = defaultValue;
    }

    public DefaultPiecewiseTransform1D(T[] domainElements) {
        super(domainElements != null && !(domainElements instanceof DefaultConstantPiecewiseTransformElement[]) ? domainElements : null);
    }

    @Override
    public double transform(double value) throws TransformException {
        DefaultPiecewiseTransform1DElement piece = (DefaultPiecewiseTransform1DElement)this.findDomainElement(value);
        if (piece == null) {
            if (this.hasDefaultValue()) {
                return this.getDefaultValue();
            }
            throw new TransformException(Errors.format(5, new Double(value)));
        }
        return piece.transform(value);
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        PiecewiseUtilities.checkDimension(point);
        return new Matrix1(this.derivative(point.getOrdinate(0)));
    }

    @Override
    public double derivative(double value) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "derivate"));
    }

    @Override
    public final int getSourceDimensions() {
        return 1;
    }

    @Override
    public final int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        throw new UnsupportedOperationException(Errors.format(15, "inverse"));
    }

    @Override
    public boolean isIdentity() {
        throw new UnsupportedOperationException(Errors.format(15, "isIdentity"));
    }

    @Override
    public String toWKT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format(15, "toWKT"));
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws MismatchedDimensionException, TransformException {
        PiecewiseUtilities.ensureNonNull("ptSrc", ptSrc);
        PiecewiseUtilities.checkDimension(ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            PiecewiseUtilities.checkDimension(ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = Utilities.hash(this.defaultValue, this.hashCode);
        this.hashCode = Utilities.hash(this.hasDefaultValue, this.hashCode);
        this.hashCode = Utilities.hash(super.hashCode(), this.hashCode);
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DefaultPiecewiseTransform1D) {
            DefaultPiecewiseTransform1D that = (DefaultPiecewiseTransform1D)object;
            if (this.hasDefaultValue != that.hasDefaultValue) {
                return false;
            }
            if (Utilities.equals(this.defaultValue, that.defaultValue)) {
                // empty if block
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultPiecewiseTransform1D.class;
    }
}

