/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.BaseCoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

class BandMergeNode
extends BaseCoverageProcessingNode
implements CoverageProcessingNode {
    private Stack<RenderedImage> intermediateOps = new Stack();

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(1);
    }

    @Override
    public synchronized void dispose(boolean force) {
        Iterator it = this.intermediateOps.iterator();
        while (it.hasNext()) {
            PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)it.next());
            image.dispose();
        }
        super.dispose(force);
    }

    public BandMergeNode(Hints hints) {
        super(3, hints, SimpleInternationalString.wrap("BandMergeNode"), SimpleInternationalString.wrap("Node which applies a BandMergeNode following SLD 1.0 spec."));
    }

    @Override
    protected GridCoverage execute() {
        assert (Thread.holdsLock(this));
        assert (this.getSources().size() <= 3);
        List<CoverageProcessingNode> sources = this.getSources();
        if (sources != null && !sources.isEmpty()) {
            int size = sources.size();
            if (size == 1) {
                return this.getSource(0).getOutput();
            }
            if (size != 3) {
                throw new IllegalArgumentException(Errors.format(1, size));
            }
            Iterator<CoverageProcessingNode> it = sources.iterator();
            RenderedImage op = null;
            GridGeometry2D gridGeometry = null;
            ImageLayout layout = null;
            Hints hints = this.getHints();
            ArrayList<GridCoverage2D> sourceGridCoverages = new ArrayList<GridCoverage2D>();
            do {
                CoverageProcessingNode currentSourceNode = it.next();
                GridCoverage2D currentSourceCoverage = (GridCoverage2D)currentSourceNode.getOutput();
                sourceGridCoverages.add(currentSourceCoverage);
                GridGeometry2D gg = currentSourceCoverage.getGridGeometry();
                if (gridGeometry == null) {
                    gridGeometry = gg;
                    ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, currentSourceCoverage.getRenderedImage().getSampleModel().getDataType());
                    layout = new ImageLayout();
                    layout.setColorModel(cm);
                } else if (!gg.equals(gridGeometry)) {
                    throw new IllegalArgumentException(Errors.format(6, "BandMerge"));
                }
                if (op == null) {
                    op = currentSourceCoverage.getRenderedImage();
                    continue;
                }
                op = BandMergeDescriptor.create(op, currentSourceCoverage.getRenderedImage(), hints);
                this.intermediateOps.add(op);
            } while (it.hasNext());
            if (layout != null) {
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            op = FormatDescriptor.create(op, op.getSampleModel().getDataType(), hints);
            GridSampleDimension[] sd = new GridSampleDimension[op.getSampleModel().getNumBands()];
            for (int i = 0; i < sd.length; ++i) {
                sd[i] = new GridSampleDimension(TypeMap.getColorInterpretation(op.getColorModel(), i).name());
            }
            return this.getCoverageFactory().create((CharSequence)"BandMerge", op, gridGeometry, null, sourceGridCoverages.toArray(new GridCoverage[sourceGridCoverages.size()]), null);
        }
        throw new IllegalStateException(Errors.format(3, "BandMergeNode"));
    }
}

