/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.pdf.PdfContentByte;
import java.util.HashMap;
import java.util.Map;
import org.mapfish.geo.MfFeature;
import org.mapfish.geo.MfFeatureCollection;
import org.mapfish.geo.MfGeo;
import org.mapfish.geo.MfGeometry;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.renderers.vector.GeometriesRenderer;
import org.mapfish.print.map.renderers.vector.StyledMfFeature;

public abstract class FeaturesRenderer<T extends MfGeo> {
    private static final Map<Class<?>, FeaturesRenderer<?>> RENDERERS = new HashMap();

    public static void render(RenderingContext context, PdfContentByte dc, MfGeo geo, AffineTransform affineTransform) {
        FeaturesRenderer<?> renderer = RENDERERS.get(geo.getClass());
        if (renderer == null) {
            throw new RuntimeException("Rendering of " + geo.getClass().getName() + " not supported");
        }
        renderer.renderImpl(context, dc, geo, affineTransform);
    }

    protected abstract void renderImpl(RenderingContext var1, PdfContentByte var2, T var3, AffineTransform var4);

    static {
        RENDERERS.put(StyledMfFeature.class, new FeatureRenderer());
        RENDERERS.put(MfFeatureCollection.class, new FeatureCollectionRenderer());
        RENDERERS.put(MfGeometry.class, new GeometryRenderer());
    }

    private static class GeometryRenderer
    extends FeaturesRenderer<MfGeometry> {
        private GeometryRenderer() {
        }

        @Override
        protected void renderImpl(RenderingContext context, PdfContentByte dc, MfGeometry geo, AffineTransform affineTransform) {
            GeometriesRenderer.render(context, dc, null, geo.getInternalGeometry(), affineTransform);
        }
    }

    private static class FeatureCollectionRenderer
    extends FeaturesRenderer<MfFeatureCollection> {
        private FeatureCollectionRenderer() {
        }

        @Override
        protected void renderImpl(RenderingContext context, PdfContentByte dc, MfFeatureCollection geo, AffineTransform affineTransform) {
            for (MfFeature cur : geo.getCollection()) {
                FeatureCollectionRenderer.render(context, dc, cur, affineTransform);
            }
        }
    }

    private static class FeatureRenderer
    extends FeaturesRenderer<StyledMfFeature> {
        private FeatureRenderer() {
        }

        @Override
        protected void renderImpl(RenderingContext context, PdfContentByte dc, StyledMfFeature geo, AffineTransform affineTransform) {
            MfGeometry theGeom = geo.getMfGeometry();
            if (theGeom != null && geo.isDisplayed()) {
                GeometriesRenderer.render(context, dc, geo.getStyle(), theGeom.getInternalGeometry(), affineTransform);
            }
        }
    }
}

