/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.opengis.parameter.ParameterValue;

public class PolarStereographicHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, boolean wrap) {
        MapProjection mapProjection = CRS.getMapProjection(renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof PolarStereographic) {
            boolean north;
            ParameterValue<?> stdParallel = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.STANDARD_PARALLEL_1.getName().getCode());
            if (stdParallel != null) {
                north = stdParallel.doubleValue() > 0.0;
            } else {
                ParameterValue<?> latOrigin = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().getCode());
                if (latOrigin != null) {
                    north = latOrigin.doubleValue() > 0.0;
                } else {
                    return null;
                }
            }
            ReferencedEnvelope validArea = north ? new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, 0.0, 90.0, DefaultGeographicCRS.WGS84) : new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, -90.0, 0.0, DefaultGeographicCRS.WGS84);
            return new ProjectionHandler(renderingEnvelope, validArea);
        }
        return null;
    }
}

