/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Watchdog
implements Runnable {
    public static final Log LOGGER = LogFactory.getLog(Watchdog.class);
    protected Thread thread = null;
    private boolean stop = false;
    private Set<Sheep> sheeps = new HashSet<Sheep>();
    private final long watchdogPeriod;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private static final long POLLING_TIME = 1000L;

    protected Watchdog(long watchdogPeriod) {
        this.watchdogPeriod = watchdogPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sheep createSheep(String name, long worstFrequency) {
        Sheep sheep = new Sheep(name, worstFrequency);
        try {
            this.lock.lock();
            this.sheeps.add(sheep);
            Sheep sheep2 = sheep;
            return sheep2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() {
        if (this.thread != null) {
            throw new RuntimeException("Watchdog started twice");
        }
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.start();
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        try {
            this.lock.lock();
            this.stop = true;
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.thread.join(1000L);
            this.thread = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.lock.lock();
            long currentHeartbeat = System.currentTimeMillis();
            while (!this.stop) {
                if (this.stillAlive()) {
                    this.lock.unlock();
                    try {
                        this.heartbeat();
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot send watchdog event", e);
                        this.lock.unlock();
                        return;
                    }
                    this.lock.lock();
                    long toSleep = (currentHeartbeat += this.watchdogPeriod) - System.currentTimeMillis();
                    if (toSleep <= 0L) continue;
                    this.condition.await(toSleep, TimeUnit.MILLISECONDS);
                    continue;
                }
                try {
                    this.condition.await(1000L, TimeUnit.MILLISECONDS);
                    currentHeartbeat = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Un-expected exception", ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stillAlive() {
        try {
            this.lock.lock();
            if (this.sheeps.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            long now = System.currentTimeMillis();
            boolean alive = false;
            int nbInactif = 0;
            for (Sheep sheep : this.sheeps) {
                if (sheep.isActive()) {
                    if (sheep.isStillAlive(now)) {
                        alive = true;
                        continue;
                    }
                    this.timeout(sheep);
                    continue;
                }
                ++nbInactif;
            }
            boolean bl = alive || nbInactif == this.sheeps.size();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void heartbeat() throws IOException, ClassNotFoundException;

    protected abstract void timeout(Sheep var1);

    public class Sheep {
        private final String name;
        private final long worstFrequency;
        private final AtomicLong lastSeen = new AtomicLong(0L);
        private String lastMessage = null;
        private boolean registered = true;

        private Sheep(String name, long worstFrequency) {
            this.name = name;
            this.worstFrequency = worstFrequency;
        }

        public final void stillAlive(String message) {
            if (!this.registered) {
                throw new RuntimeException(this.name + " is already un-registered");
            }
            this.lastSeen.set(System.currentTimeMillis());
            this.lastMessage = message;
        }

        private boolean isStillAlive(long now) {
            return now - this.lastSeen.get() <= this.worstFrequency;
        }

        private boolean isActive() {
            return this.lastMessage != null;
        }

        public String toString() {
            return this.name + " {" + (System.currentTimeMillis() - this.lastSeen.get()) + " > " + this.worstFrequency + "} lastMessage=" + this.lastMessage;
        }

        public void unregister() {
            this.registered = false;
            try {
                Watchdog.this.lock.lock();
                if (!Watchdog.this.sheeps.remove(this)) {
                    LOGGER.error("Unknown sheep being un-registered: " + this);
                }
            }
            finally {
                Watchdog.this.lock.unlock();
            }
        }
    }
}

