/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.log4j;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class InstrumentedAppender
extends AppenderSkeleton {
    private final MetricRegistry registry;
    private Meter all;
    private Meter trace;
    private Meter debug;
    private Meter info;
    private Meter warn;
    private Meter error;
    private Meter fatal;

    public InstrumentedAppender(String registryName) {
        this(SharedMetricRegistries.getOrCreate(registryName));
    }

    public InstrumentedAppender(MetricRegistry registry) {
        this.registry = registry;
        this.setName(MetricRegistry.name(Appender.class, new String[0]));
    }

    @Override
    public void activateOptions() {
        this.all = this.registry.meter(MetricRegistry.name(this.getName(), "all"));
        this.trace = this.registry.meter(MetricRegistry.name(this.getName(), "trace"));
        this.debug = this.registry.meter(MetricRegistry.name(this.getName(), "debug"));
        this.info = this.registry.meter(MetricRegistry.name(this.getName(), "info"));
        this.warn = this.registry.meter(MetricRegistry.name(this.getName(), "warn"));
        this.error = this.registry.meter(MetricRegistry.name(this.getName(), "error"));
        this.fatal = this.registry.meter(MetricRegistry.name(this.getName(), "fatal"));
    }

    @Override
    protected void append(LoggingEvent event) {
        this.all.mark();
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark();
                break;
            }
            case 10000: {
                this.debug.mark();
                break;
            }
            case 20000: {
                this.info.mark();
                break;
            }
            case 30000: {
                this.warn.mark();
                break;
            }
            case 40000: {
                this.error.mark();
                break;
            }
            case 50000: {
                this.fatal.mark();
                break;
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }
}

