/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.filter.text.commons.ExpressionToText;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;

public final class FilterToTextUtil {
    private static final Logger LOGGER = Logger.getLogger(FilterToTextUtil.class.getName());

    private FilterToTextUtil() {
    }

    public static StringBuilder asStringBuilder(Object extraData) {
        if (extraData instanceof StringBuilder) {
            return (StringBuilder)extraData;
        }
        return new StringBuilder();
    }

    public static Object buildInclude(Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("INCLUDE");
        return output;
    }

    public static Object buildExclude(Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("EXCLUDE");
        return output;
    }

    public static Object buildBinaryLogicalOperator(String operator, FilterVisitor visitor, BinaryLogicOperator filter, Object extraData) {
        LOGGER.finer("exporting And filter");
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        List<Filter> children = filter.getChildren();
        if (children != null) {
            output.append("(");
            Iterator<Filter> i = children.iterator();
            while (i.hasNext()) {
                Filter child = i.next();
                child.accept(visitor, output);
                if (!i.hasNext()) continue;
                output.append(" ").append(operator).append(" ");
            }
            output.append(")");
        }
        return output;
    }

    public static Object buildBetween(PropertyIsBetween filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsBetween");
        ExpressionToText exprVisitor = new ExpressionToText();
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept(exprVisitor, output);
        output.append(" BETWEEN ");
        filter.getLowerBoundary().accept(exprVisitor, output);
        output.append(" AND ");
        filter.getUpperBoundary().accept(exprVisitor, output);
        return output;
    }

    public static Object buildNot(FilterVisitor filterToCQL, Not filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("NOT (");
        filter.getFilter().accept(filterToCQL, output);
        output.append(")");
        return output;
    }

    public static Object buildComparison(BinaryComparisonOperator filter, Object extraData, String operator) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        ExpressionToText visitor = new ExpressionToText();
        Expression expr = filter.getExpression1();
        expr.accept(visitor, output);
        output.append(" ").append(operator).append(" ");
        filter.getExpression2().accept(visitor, output);
        return output;
    }

    public static Object buildIsLike(PropertyIsLike filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        String pattern = filter.getLiteral();
        Expression expr = filter.getExpression();
        expr.accept(new ExpressionToText(), output);
        if (filter.isMatchingCase()) {
            output.append(" LIKE ");
        } else {
            output.append(" ILIKE ");
        }
        output.append("'");
        output.append(pattern);
        output.append("'");
        return output;
    }

    public static Object buildIsNull(PropertyIsNull filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept(new ExpressionToText(), output);
        output.append(" IS NULL");
        return output;
    }

    public static Object buildBBOX(BBOX filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("BBOX(");
        output.append(filter.getPropertyName());
        output.append(", ");
        output.append(filter.getMinX());
        output.append(",");
        output.append(filter.getMinY());
        output.append(",");
        output.append(filter.getMaxX());
        output.append(",");
        output.append(filter.getMaxY());
        output.append(")");
        return output;
    }

    public static Object buildDistanceBufferOperation(String geoOperation, DistanceBufferOperator filter, Object extraData) {
        LOGGER.finer("exporting " + geoOperation);
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append(geoOperation).append("(");
        Expression expr = filter.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        expr.accept(visitor, output);
        output.append(", ");
        filter.getExpression2().accept(visitor, output);
        output.append(")");
        return output;
    }

    public static Object buildDWithin(DWithin filter, Object extraData) {
        LOGGER.finer("exporting DWITHIN");
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("DWITHIN(");
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        propertyName.accept(visitor, output);
        output.append(", ");
        filter.getExpression2().accept(visitor, output);
        output.append(", ");
        output.append(filter.getDistance());
        output.append(", ");
        output.append(filter.getDistanceUnits());
        output.append(")");
        return output;
    }

    public static Object buildBinarySpatialOperator(String spatialOperator, BinarySpatialOperator filter, Object extraData) {
        LOGGER.finer("exporting " + spatialOperator);
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append(spatialOperator).append("(");
        Expression expr = filter.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        expr.accept(visitor, output);
        output.append(", ");
        filter.getExpression2().accept(visitor, output);
        output.append(")");
        return output;
    }

    public static Object buildBinaryTemporalOperator(String temporalOperator, BinaryTemporalOperator filter, Object extraData) {
        LOGGER.finer("exporting " + temporalOperator);
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        propertyName.accept(visitor, output);
        output.append(" ").append(temporalOperator).append(" ");
        Literal expr2 = (Literal)filter.getExpression2();
        expr2.accept(visitor, output);
        return output;
    }

    public static Object buildDuring(During during, Object extraData) {
        LOGGER.finer("exporting DURING");
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)during.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        propertyName.accept(visitor, output);
        output.append(" DURING ");
        Literal expr2 = (Literal)during.getExpression2();
        expr2.accept(visitor, output);
        return output;
    }
}

