/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Point;
import java.awt.geom.AffineTransform;
import org.geotools.geometry.jts.AbstractLiteIterator;

public final class PointIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private Point point;
    private boolean done;
    private boolean moved;

    public PointIterator(Point point, AffineTransform at) {
        if (at == null) {
            at = new AffineTransform();
        }
        this.at = at;
        this.point = point;
        this.done = false;
        this.moved = false;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public void next() {
        this.done = true;
    }

    @Override
    public boolean isDone() {
        return this.done && this.moved;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (!this.done && !this.moved) {
            coords[0] = this.point.getX();
            coords[1] = this.point.getY();
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }
        coords[0] = this.point.getX();
        coords[1] = this.point.getY();
        this.at.transform(coords, 0, coords, 0, 1);
        this.moved = true;
        return 1;
    }
}

