/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.renderer.i18n.Errors;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class DefaultLinearPiecewiseTransform1DElement
extends DefaultPiecewiseTransform1DElement
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = 4026834241134908025L;
    private static final Logger LOGGER = Logging.getLogger("org.geotools.referencing.piecewise.DefaultLinearPiecewiseTransform1DElement");
    private double outputMaximum;
    private double outputMinimum;
    private NumberRange<? extends Number> outputRange;
    private boolean outputMinimumNaN;
    private boolean outputMaximumNaN;
    private boolean outputMinimumInfinite;
    private boolean outputMaximumInfinite;

    public DefaultLinearPiecewiseTransform1DElement(CharSequence name, NumberRange<? extends Number> inRange, NumberRange<? extends Number> outRange) {
        block14: {
            super(name, inRange);
            this.outputRange = outRange;
            Class type = outRange.getElementClass();
            boolean minInc = outRange.isMinIncluded();
            boolean maxInc = outRange.isMaxIncluded();
            this.outputMinimum = PiecewiseUtilities.doubleValue(type, (Number)outRange.getMinValue(), minInc ? 0 : 1);
            this.outputMaximum = PiecewiseUtilities.doubleValue(type, (Number)outRange.getMaxValue(), maxInc ? 0 : -1);
            this.outputMinimumNaN = Double.isNaN(this.outputMinimum);
            this.outputMaximumNaN = Double.isNaN(this.outputMaximum);
            this.outputMinimumInfinite = Double.isInfinite(this.outputMinimum);
            this.outputMaximumInfinite = Double.isInfinite(this.outputMaximum);
            if (this.outputMinimumInfinite || this.outputMinimumInfinite) {
                throw new IllegalArgumentException(Errors.format(14, this.outputRange.getMinValue(), this.outputRange.getMaxValue()));
            }
            int compareOutBounds = PiecewiseUtilities.compare(this.outputMinimum, this.outputMaximum);
            if (compareOutBounds > 0) {
                throw new IllegalArgumentException(Errors.format(14, this.outputRange.getMinValue(), this.outputRange.getMaxValue()));
            }
            if (this.isInputMaximumNaN() && this.isInputMinimumNaN()) {
                if (compareOutBounds == 0) {
                    this.setTransform(LinearTransform1D.create(0.0, this.outputMinimum));
                    this.setInverse(LinearTransform1D.create(this.outputMinimum, 0.0));
                    return;
                }
                throw new IllegalArgumentException(Errors.format(14, this.outputRange.getMinValue(), this.outputRange.getMaxValue()));
            }
            if (this.isInputMaximumInfinite() || this.isInputMinimumInfinite()) {
                if (compareOutBounds == 0) {
                    this.setTransform(PiecewiseUtilities.createLinearTransform1D(0.0, this.outputMinimum));
                    this.setInverse(null);
                    return;
                }
                throw new IllegalArgumentException(Errors.format(14, this.outputRange.getMinValue(), this.outputRange.getMaxValue()));
            }
            MathTransform1D transform = PiecewiseUtilities.createLinearTransform1D(inRange, NumberRange.create(this.outputMinimum, this.outputMaximum));
            this.setTransform(transform);
            assert (transform instanceof LinearTransform1D);
            assert (!Double.isNaN(((LinearTransform1D)transform).scale) && !Double.isInfinite(((LinearTransform1D)transform).scale));
            LinearTransform1D tempTransform = (LinearTransform1D)transform;
            double scale = tempTransform.scale;
            if (Math.abs(scale) < 1.0E-6) {
                if (PiecewiseUtilities.compare(this.getInputMaximum(), this.getInputMinimum()) == 0) {
                    this.setInverse(LinearTransform1D.create(0.0, this.getInputMinimum()));
                } else {
                    this.setInverse(null);
                }
            } else {
                try {
                    this.setInverse(transform.inverse());
                }
                catch (NoninvertibleTransformException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block14;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public double getOutputMaximum() {
        return this.outputMaximum;
    }

    public double getOutputMinimum() {
        return this.outputMinimum;
    }

    public NumberRange<? extends Number> getOutputRange() {
        return this.outputRange;
    }

    public boolean isOutputMinimumNaN() {
        return this.outputMinimumNaN;
    }

    public boolean isOutputMaximumNaN() {
        return this.outputMaximumNaN;
    }

    public boolean isOutputMinimumInfinite() {
        return this.outputMinimumInfinite;
    }

    public boolean isOutputMaximumInfinite() {
        return this.outputMaximumInfinite;
    }

    public double getScale() {
        LinearTransform1D transform = (LinearTransform1D)this.getTransform();
        return transform.scale;
    }

    public double getOffset() {
        LinearTransform1D transform = (LinearTransform1D)this.getTransform();
        return transform.offset;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append("\n").append("output range=").append(this.outputRange);
        return buffer.toString();
    }

    @Override
    protected Class<?> getEquivalenceClass() {
        return DefaultLinearPiecewiseTransform1DElement.class;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultLinearPiecewiseTransform1DElement)) {
            return false;
        }
        DefaultLinearPiecewiseTransform1DElement that = (DefaultLinearPiecewiseTransform1DElement)obj;
        if (that.getEquivalenceClass() != this.getEquivalenceClass()) {
            return false;
        }
        if (!Utilities.equals(this.outputRange, that.outputRange)) {
            return false;
        }
        if (!Utilities.equals(this.outputMaximum, that.outputMaximum)) {
            return false;
        }
        if (!Utilities.equals(this.outputMinimum, that.outputMinimum)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 37;
        hashCode = Utilities.hash(this.outputRange, hashCode);
        hashCode = Utilities.hash(this.outputMaximum, hashCode);
        hashCode = Utilities.hash(this.outputMinimum, hashCode);
        hashCode = Utilities.hash(super.hashCode(), hashCode);
        return hashCode;
    }
}

