/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.renderer.i18n.Errors;
import org.geotools.util.NumberRange;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class DefaultPassthroughPiecewiseTransform1DElement
extends DefaultPiecewiseTransform1DElement
implements PiecewiseTransform1DElement {
    private static final long serialVersionUID = -2420723761115130075L;

    DefaultPassthroughPiecewiseTransform1DElement(CharSequence name) throws IllegalArgumentException {
        super(name, (NumberRange<? extends Number>)NumberRange.create(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    DefaultPassthroughPiecewiseTransform1DElement(CharSequence name, NumberRange<? extends Number> valueRange) throws IllegalArgumentException {
        super(name, valueRange);
    }

    @Override
    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.", this.getClass());
    }

    @Override
    public double transform(double value) throws TransformException {
        if (this.checkContainment(value)) {
            return value;
        }
        throw new IllegalArgumentException(Errors.format(9, "value"));
    }

    private boolean checkContainment(double value) throws TransformException {
        return this.contains(value);
    }

    @Override
    public double derivative(double value) throws TransformException {
        if (this.checkContainment(value)) {
            return 1.0;
        }
        throw new IllegalArgumentException(Errors.format(9, "value"));
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        PiecewiseUtilities.checkDimension(ptSrc);
        PiecewiseUtilities.ensureNonNull("DirectPosition", ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            PiecewiseUtilities.checkDimension(ptDst);
        }
        double value = ptSrc.getOrdinate(0);
        this.checkContainment(value);
        ptDst.setOrdinate(0, this.transform(value));
        return ptDst;
    }

    @Override
    public void transform(double[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public void transform(float[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return LinearTransform1D.IDENTITY;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public Matrix derivative(DirectPosition dp) throws MismatchedDimensionException, TransformException {
        PiecewiseUtilities.ensureNonNull("DirectPosition", dp);
        PiecewiseUtilities.checkDimension(dp);
        if (this.checkContainment(dp.getOrdinate(0))) {
            return new Matrix1(1.0);
        }
        throw new IllegalArgumentException(Errors.format(9, "DirectPosition"));
    }
}

