/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.net.URI;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.mapfish.print.config.SecurityStrategy;

public class BasicAuthSecurity
extends SecurityStrategy {
    String username = null;
    String password = null;
    boolean preemptive = false;

    @Override
    public void configure(URI uri, HttpClient httpClient) {
        if (this.username == null || this.password == null) {
            throw new IllegalStateException("username and password configuration of BasicAuthSecurity is required");
        }
        if (this.preemptive) {
            httpClient.getParams().setAuthenticationPreemptive(true);
        }
        httpClient.getState().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), new UsernamePasswordCredentials(this.username, this.password));
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPreemptive(boolean preemptive) {
        this.preemptive = preemptive;
    }
}

