/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.renderers.vector.GeometriesRenderer;
import org.mapfish.print.map.renderers.vector.PolygonRenderer;
import org.mapfish.print.utils.PJsonObject;

public class PointRenderer
extends GeometriesRenderer<Point> {
    private static final Map<String, float[]> SYMBOLS = new HashMap<String, float[]>();

    private static float[] normalizeSymbol(float[] coords) {
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        for (int i = 0; i < coords.length; i += 2) {
            float x = coords[i];
            float y = coords[i + 1];
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        float width = maxX - minX;
        float height = maxY - minY;
        for (int i = 0; i < coords.length; i += 2) {
            coords[i] = (coords[i] - minX) / width;
            coords[i + 1] = (coords[i + 1] - minY) / height;
        }
        return coords;
    }

    private float[] rotateSymbol(float[] symbol, float rotation) {
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        for (int i = 0; i < symbol.length; i += 2) {
            float x = symbol[i];
            float y = symbol[i + 1];
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        float width = maxX - minX;
        float height = maxY - minY;
        AffineTransform rotationTransform = AffineTransform.getRotateInstance(Math.toRadians(rotation), width / 2.0f, height / 2.0f);
        for (int i = 0; i < symbol.length; i += 2) {
            float x = symbol[i];
            float y = symbol[i + 1];
            Coordinate coordinate2 = new Coordinate(x, y);
            coordinate2 = PointRenderer.transformCoordinate(coordinate2, rotationTransform);
            symbol[i] = (float)coordinate2.x;
            symbol[i + 1] = (float)coordinate2.y;
        }
        return symbol;
    }

    @Override
    protected void renderImpl(RenderingContext context, PdfContentByte dc, PJsonObject style, Point geometry, AffineTransform affineTransform) {
        PdfGState state = new PdfGState();
        Coordinate coordinate = PointRenderer.transformCoordinate((Coordinate)geometry.getCoordinate().clone(), affineTransform);
        float pointRadius = style.optFloat("pointRadius", 4.0f).floatValue();
        float f = context.getStyleFactor();
        String graphicName = style.optString("graphicName");
        float width = style.optFloat("graphicWidth", pointRadius * 2.0f).floatValue();
        float height = style.optFloat("graphicHeight", pointRadius * 2.0f).floatValue();
        float offsetX = style.optFloat("graphicXOffset", -width / 2.0f).floatValue();
        float offsetY = style.optFloat("graphicYOffset", -height / 2.0f).floatValue();
        float rotation = style.optFloat("rotation", 0.0f).floatValue();
        if (style.optString("externalGraphic") != null && style.optString("externalGraphic").length() > 0) {
            float opacity = style.optFloat("graphicOpacity", style.optFloat("fillOpacity", 1.0f).floatValue()).floatValue();
            state.setFillOpacity(opacity);
            state.setStrokeOpacity(opacity);
            dc.setGState(state);
            try {
                Image image = PDFUtils.createImage(context, width * f, height * f, new URI(style.getString("externalGraphic")), 0.0f);
                image.setRotationDegrees(-rotation);
                float rotationOffsetX = (image.getScaledWidth() - image.getPlainWidth()) / 2.0f;
                float rotationOffsetY = (image.getScaledHeight() - image.getPlainHeight()) / 2.0f;
                image.setAbsolutePosition((float)coordinate.x + offsetX * f - rotationOffsetX, (float)coordinate.y - height * f - offsetY * f - rotationOffsetY);
                dc.addImage(image);
            }
            catch (BadElementException e) {
                context.addError(e);
            }
            catch (URISyntaxException e) {
                context.addError(e);
            }
            catch (DocumentException e) {
                context.addError(e);
            }
        } else if (graphicName != null && !graphicName.equalsIgnoreCase("circle")) {
            PolygonRenderer.applyStyle(context, dc, style, state);
            float[] symbol = (float[])SYMBOLS.get(graphicName).clone();
            if (symbol == null) {
                throw new InvalidValueException("graphicName", graphicName);
            }
            if (rotation != 0.0f) {
                symbol = this.rotateSymbol(symbol, -rotation);
            }
            dc.setGState(state);
            dc.moveTo((float)coordinate.x + symbol[0] * width * f + offsetX * f, (float)coordinate.y + symbol[1] * height * f + offsetY * f);
            for (int i = 2; i < symbol.length - 2; i += 2) {
                dc.lineTo((float)coordinate.x + symbol[i] * width * f + offsetX * f, (float)coordinate.y + symbol[i + 1] * height * f + offsetY * f);
            }
            dc.closePath();
            dc.fillStroke();
        } else {
            PolygonRenderer.applyStyle(context, dc, style, state);
            dc.setGState(state);
            dc.circle((float)coordinate.x, (float)coordinate.y, pointRadius * f);
            this.renderStrokeAndFill(dc, style.optBool("stroke", true), style.optBool("fill", true));
        }
    }

    private void renderStrokeAndFill(PdfContentByte dc, boolean stroke, boolean fill) {
        if (stroke && fill) {
            dc.fillStroke();
        } else if (stroke) {
            dc.stroke();
        } else if (fill) {
            dc.fill();
        }
    }

    static {
        SYMBOLS.put("star", PointRenderer.normalizeSymbol(new float[]{350.0f, 75.0f, 379.0f, 161.0f, 469.0f, 161.0f, 397.0f, 215.0f, 423.0f, 301.0f, 350.0f, 250.0f, 277.0f, 301.0f, 303.0f, 215.0f, 231.0f, 161.0f, 321.0f, 161.0f, 350.0f, 75.0f}));
        SYMBOLS.put("cross", PointRenderer.normalizeSymbol(new float[]{4.0f, 0.0f, 6.0f, 0.0f, 6.0f, 4.0f, 10.0f, 4.0f, 10.0f, 6.0f, 6.0f, 6.0f, 6.0f, 10.0f, 4.0f, 10.0f, 4.0f, 6.0f, 0.0f, 6.0f, 0.0f, 4.0f, 4.0f, 4.0f, 4.0f, 0.0f}));
        SYMBOLS.put("x", PointRenderer.normalizeSymbol(new float[]{0.0f, 0.0f, 25.0f, 0.0f, 50.0f, 35.0f, 75.0f, 0.0f, 100.0f, 0.0f, 65.0f, 50.0f, 100.0f, 100.0f, 75.0f, 100.0f, 50.0f, 65.0f, 25.0f, 100.0f, 0.0f, 100.0f, 35.0f, 50.0f, 0.0f, 0.0f}));
        SYMBOLS.put("square", PointRenderer.normalizeSymbol(new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f}));
        SYMBOLS.put("triangle", PointRenderer.normalizeSymbol(new float[]{0.0f, 10.0f, 10.0f, 10.0f, 5.0f, 0.0f, 0.0f, 10.0f}));
    }
}

