/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog(ResourceArrayPropertyEditor.class);
    private final PropertyResolver propertyResolver;
    private final ResourcePatternResolver resourcePatternResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceArrayPropertyEditor() {
        this(new PathMatchingResourcePatternResolver(), new StandardEnvironment(), true);
    }

    @Deprecated
    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this(resourcePatternResolver, new StandardEnvironment(), true);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, PropertyResolver propertyResolver) {
        this(resourcePatternResolver, propertyResolver, true);
    }

    @Deprecated
    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, boolean ignoreUnresolvablePlaceholders) {
        this(resourcePatternResolver, new StandardEnvironment(), ignoreUnresolvablePlaceholders);
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver, PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        this.resourcePatternResolver = resourcePatternResolver;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setAsText(String text) {
        String pattern = this.resolvePath(text).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(pattern));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value instanceof Collection || value instanceof Object[] && !(value instanceof Resource[])) {
            Collection input = value instanceof Collection ? (Collection)value : (Collection)Arrays.asList((Object[])value);
            ArrayList<Resource> merged = new ArrayList<Resource>();
            for (Object element : input) {
                if (element instanceof String) {
                    String pattern = this.resolvePath((String)element).trim();
                    try {
                        Resource[] resources;
                        Resource[] resourceArray = resources = this.resourcePatternResolver.getResources(pattern);
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Resource resource = resourceArray[n2];
                            if (!merged.contains(resource)) {
                                merged.add(resource);
                            }
                            ++n2;
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Could not retrieve resources for pattern '" + pattern + "'", ex);
                    }
                    continue;
                }
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    if (merged.contains(resource)) continue;
                    merged.add(resource);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + element + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(merged.toArray(new Resource[merged.size()]));
        } else {
            super.setValue(value);
        }
    }

    protected String resolvePath(String path) {
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path) : this.propertyResolver.resolveRequiredPlaceholders(path);
    }
}

