/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;

public class HttpClientMetricNameStrategies {
    public static final HttpClientMetricNameStrategy METHOD_ONLY = new HttpClientMetricNameStrategy(){

        @Override
        public String getNameFor(String name, HttpRequest request) {
            return MetricRegistry.name(HttpClient.class, name, HttpClientMetricNameStrategies.methodNameString(request));
        }
    };
    public static final HttpClientMetricNameStrategy HOST_AND_METHOD = new HttpClientMetricNameStrategy(){

        @Override
        public String getNameFor(String name, HttpRequest request) {
            RequestLine requestLine = request.getRequestLine();
            URI uri = URI.create(requestLine.getUri());
            return MetricRegistry.name(HttpClient.class, name, uri.getHost(), HttpClientMetricNameStrategies.methodNameString(request));
        }
    };
    public static final HttpClientMetricNameStrategy QUERYLESS_URL_AND_METHOD = new HttpClientMetricNameStrategy(){

        @Override
        public String getNameFor(String name, HttpRequest request) {
            try {
                RequestLine requestLine = request.getRequestLine();
                URIBuilder url = new URIBuilder(requestLine.getUri());
                return MetricRegistry.name(HttpClient.class, name, url.removeQuery().build().toString(), HttpClientMetricNameStrategies.methodNameString(request));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    };

    private static String methodNameString(HttpRequest request) {
        return request.getRequestLine().getMethod().toLowerCase() + "-requests";
    }
}

