/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Iterator;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public class FeatureCollectionIteration {
    protected final Handler handler;
    private final FeatureCollection<?, ?> collection;

    public FeatureCollectionIteration(Handler handler, FeatureCollection<?, ?> collection) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        this.handler = handler;
        this.collection = collection;
    }

    public static void iteration(Handler handler, FeatureCollection<?, ?> collection) {
        FeatureCollectionIteration iteration = new FeatureCollectionIteration(handler, collection);
        iteration.iterate();
    }

    public void iterate() {
        this.walker(this.collection);
    }

    protected void walker(FeatureCollection<?, ?> collection) {
        this.handler.handleFeatureCollection(collection);
        this.iterate(collection.iterator());
        this.handler.endFeatureCollection(collection);
    }

    protected void iterate(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            this.walker((Feature)iterator.next());
        }
    }

    protected void walker(Feature feature) {
        FeatureType schema = feature.getType();
        this.handler.handleFeature(feature);
        for (Property property : feature.getProperties()) {
            Class<?> binding = property.getType().getBinding();
            if (FeatureCollection.class.isAssignableFrom(binding)) {
                this.walker((FeatureCollection)property.getValue());
                continue;
            }
            if (Feature.class.isAssignableFrom(binding)) {
                this.walker((Feature)property.getValue());
                continue;
            }
            this.handler.handleAttribute(property.getDescriptor(), property.getValue());
        }
        this.handler.endFeature(feature);
    }

    public static interface Handler {
        public void handleFeatureCollection(FeatureCollection<?, ?> var1);

        public void endFeatureCollection(FeatureCollection<?, ?> var1);

        public void handleFeature(Feature var1);

        public void endFeature(Feature var1);

        public void handleAttribute(PropertyDescriptor var1, Object var2);
    }
}

