/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import javax.media.jai.util.ImagingException;
import org.geotools.image.TransfertRectIter;
import org.geotools.image.jai.Registry;
import org.geotools.referencing.piecewise.DefaultDomain1D;
import org.geotools.referencing.piecewise.Domain1D;
import org.geotools.referencing.piecewise.DomainElement1D;
import org.geotools.referencing.piecewise.PiecewiseTransform1DElement;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapTransform;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapTransformElement;

public class RasterClassifier
extends PointOpImage {
    public static final String OPERATION_NAME = "org.geotools.RasterClassifier";
    private final ColorMapTransform<ColorMapTransformElement> pieces;
    private int bandIndex;

    private RasterClassifier(RenderedImage image, ColorMapTransform<ColorMapTransformElement> lic, int bandIndex, RenderingHints hints) {
        super(image, RasterClassifier.prepareLayout(image, (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT), lic), (Map)hints, false);
        this.pieces = lic;
        this.bandIndex = bandIndex;
        this.permitInPlaceOperation();
    }

    private static ImageLayout prepareLayout(RenderedImage image, ImageLayout layout, ColorMapTransform<ColorMapTransformElement> lic) {
        IndexColorModel finalColorModel = lic.getColorModel();
        SampleModel finalSampleModel = lic.getSampleModel(image.getWidth(), image.getHeight());
        if (layout == null) {
            layout = new ImageLayout();
        }
        layout.setColorModel(finalColorModel);
        layout.setSampleModel(finalSampleModel);
        return layout;
    }

    @Override
    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        PlanarImage source = sources[0];
        WritableRectIter iterator = RectIterFactory.createWritable(dest, destRect);
        iterator = TransfertRectIter.create(RectIterFactory.create(source, destRect), iterator);
        if (!iterator.finishedBands()) {
            for (int i = 0; i < this.bandIndex; ++i) {
                iterator.nextBand();
            }
        }
        double gapsValue = Double.NaN;
        boolean hasGapsValue = false;
        if (this.pieces.hasDefaultValue()) {
            gapsValue = this.pieces.getDefaultValue();
            hasGapsValue = true;
        }
        DomainElement1D last = null;
        boolean useLast = this.pieces instanceof DefaultDomain1D;
        do {
            try {
                iterator.startLines();
                if (iterator.finishedLines()) continue;
                do {
                    iterator.startPixels();
                    if (iterator.finishedPixels()) continue;
                    do {
                        DomainElement1D transform;
                        double value = iterator.getSampleDouble();
                        if (useLast) {
                            if (last != null && last.contains(value)) {
                                transform = last;
                            } else {
                                last = transform = (PiecewiseTransform1DElement)this.pieces.findDomainElement(value);
                            }
                        } else {
                            transform = (PiecewiseTransform1DElement)this.pieces.findDomainElement(value);
                        }
                        if (transform != null) {
                            iterator.setSample(transform.transform(value));
                            continue;
                        }
                        if (hasGapsValue) {
                            iterator.setSample(gapsValue);
                            continue;
                        }
                        throw new IllegalArgumentException(Errors.format(9, Double.toString(value)));
                    } while (!iterator.nextPixelDone());
                } while (!iterator.nextLineDone());
            }
            catch (Throwable cause) {
                throw new ImagingException(cause.getLocalizedMessage(), cause);
            }
        } while (this.bandIndex == -1 && iterator.finishedBands());
    }

    public static boolean register(JAI jai) {
        return Registry.registerRIF(jai, (OperationDescriptor)new Descriptor(), OPERATION_NAME, new CRIF());
    }

    private static final class CRIF
    extends CRIFImpl {
        private CRIF() {
        }

        @Override
        public RenderedImage create(ParameterBlock param, RenderingHints hints) {
            RenderedImage image = (RenderedImage)param.getSource(0);
            ColorMapTransform lic = (ColorMapTransform)param.getObjectParameter(0);
            int bandIndex = param.getIntParameter(1);
            return new RasterClassifier(image, lic, bandIndex, hints);
        }
    }

    private static final class Descriptor
    extends OperationDescriptorImpl {
        private static final long serialVersionUID = 7954257625240335874L;

        public Descriptor() {
            super(new String[][]{{"GlobalName", RasterClassifier.OPERATION_NAME}, {"LocalName", RasterClassifier.OPERATION_NAME}, {"Vendor", "Geotools 2"}, {"Description", "Transformation from sample to geophysics values"}, {"DocURL", "http://www.geotools.org/"}, {"Version", "1.0"}}, new String[]{"rendered"}, 1, new String[]{"Domain1D", "bandIndex"}, new Class[]{ColorMapTransform.class, Integer.class}, new Object[]{NO_PARAMETER_DEFAULT, -1}, null);
        }

        @Override
        protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
            if (!super.validateParameters(modeName, param, message)) {
                return false;
            }
            RenderedImage source = (RenderedImage)param.getSource(0);
            Domain1D lic = (Domain1D)param.getObjectParameter(0);
            if (lic == null) {
                return false;
            }
            int numBands = source.getSampleModel().getNumBands();
            int bandIndex = param.getIntParameter(1);
            if (bandIndex == -1) {
                return true;
            }
            return bandIndex >= 0 && bandIndex < numBands;
        }
    }
}

