/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.InternationalString;

public abstract class SubchainStyleVisitorCoverageProcessingAdapter
extends StyleVisitorCoverageProcessingNodeAdapter {
    private static final Logger LOGGER = Logging.getLogger(RasterSymbolizerHelper.class.getName());
    private CoverageProcessingNode sink;

    public SubchainStyleVisitorCoverageProcessingAdapter(CoverageProcessingNode adaptee) {
        super(adaptee);
    }

    public SubchainStyleVisitorCoverageProcessingAdapter(InternationalString name, InternationalString description) {
        super(name, description);
    }

    public SubchainStyleVisitorCoverageProcessingAdapter(int maxSources, InternationalString name, InternationalString description) {
        super(maxSources, name, description);
    }

    public SubchainStyleVisitorCoverageProcessingAdapter(int maxSources, Hints hints, InternationalString name, InternationalString description) {
        super(maxSources, hints, name, description);
    }

    @Override
    public synchronized void dispose(boolean force) {
        this.dispose(this.sink, force);
        super.dispose(force);
    }

    private void dispose(CoverageProcessingNode node, boolean force) {
        if (node == null) {
            return;
        }
        List<CoverageProcessingNode> sources = node.getSources();
        if (sources != null && sources.size() > 0) {
            for (CoverageProcessingNode source : sources) {
                this.dispose(source, force);
            }
        }
        node.dispose(force);
    }

    protected synchronized void setSink(CoverageProcessingNode sink) {
        SubchainStyleVisitorCoverageProcessingAdapter.ensureNotNull(sink, "sink");
        if (this.sink != null) {
            throw new IllegalStateException(Errors.format(2));
        }
        this.sink = sink;
    }

    @Override
    public synchronized GridCoverage execute() {
        if (this.sink != null) {
            return this.sink.getOutput();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Sink for this chain is null, It was probably not set.");
        }
        return null;
    }
}

