/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.shape.ExplicitBoundsShape;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class WellKnownMarkFactory
implements MarkFactory {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.rendering");
    private static Shape cross;
    private static Shape star;
    private static Shape triangle;
    private static Shape arrow;
    private static Shape X;
    static Shape hatch;
    private static Shape square;

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        if (symbolUrl == null) {
            return null;
        }
        String wellKnownName = symbolUrl.evaluate(feature, String.class);
        LOGGER.finer("fetching mark of name " + wellKnownName);
        if (wellKnownName.equalsIgnoreCase("cross")) {
            LOGGER.finer("returning cross");
            return cross;
        }
        if (wellKnownName.equalsIgnoreCase("circle")) {
            LOGGER.finer("returning circle");
            return new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0);
        }
        if (wellKnownName.equalsIgnoreCase("triangle")) {
            LOGGER.finer("returning triangle");
            return triangle;
        }
        if (wellKnownName.equalsIgnoreCase("X")) {
            LOGGER.finer("returning X");
            return X;
        }
        if (wellKnownName.equalsIgnoreCase("star")) {
            LOGGER.finer("returning star");
            return star;
        }
        if (wellKnownName.equalsIgnoreCase("arrow")) {
            LOGGER.finer("returning arrow");
            return arrow;
        }
        if (wellKnownName.equalsIgnoreCase("hatch")) {
            LOGGER.finer("returning hatch");
            return hatch;
        }
        if (wellKnownName.equalsIgnoreCase("square")) {
            LOGGER.finer("returning square");
            return square;
        }
        LOGGER.finer("Could not find the symbol, returning null");
        return null;
    }

    static {
        GeneralPath crossPath = new GeneralPath(0);
        crossPath.moveTo(0.5f, 0.125f);
        crossPath.lineTo(0.125f, 0.125f);
        crossPath.lineTo(0.125f, 0.5f);
        crossPath.lineTo(-0.125f, 0.5f);
        crossPath.lineTo(-0.125f, 0.125f);
        crossPath.lineTo(-0.5f, 0.125f);
        crossPath.lineTo(-0.5f, -0.125f);
        crossPath.lineTo(-0.125f, -0.125f);
        crossPath.lineTo(-0.125f, -0.5f);
        crossPath.lineTo(0.125f, -0.5f);
        crossPath.lineTo(0.125f, -0.125f);
        crossPath.lineTo(0.5f, -0.125f);
        crossPath.lineTo(0.5f, 0.125f);
        cross = new ExplicitBoundsShape(crossPath);
        ((ExplicitBoundsShape)cross).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        AffineTransform at = new AffineTransform();
        at.rotate(0.7853981633974483);
        X = new ExplicitBoundsShape(crossPath.createTransformedShape(at));
        ((ExplicitBoundsShape)X).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        GeneralPath starPath = new GeneralPath(0);
        starPath.moveTo(0.191f, 0.0f);
        starPath.lineTo(0.25f, 0.344f);
        starPath.lineTo(0.0f, 0.588f);
        starPath.lineTo(0.346f, 0.638f);
        starPath.lineTo(0.5f, 0.951f);
        starPath.lineTo(0.654f, 0.638f);
        starPath.lineTo(1.0f, 0.588f);
        starPath.lineTo(0.75f, 0.344f);
        starPath.lineTo(0.89f, 0.0f);
        starPath.lineTo(0.5f, 0.162f);
        starPath.lineTo(0.191f, 0.0f);
        at = new AffineTransform();
        at.translate(-0.5, -0.5);
        starPath.transform(at);
        star = new ExplicitBoundsShape(starPath);
        ((ExplicitBoundsShape)star).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        GeneralPath trianglePath = new GeneralPath(0);
        trianglePath.moveTo(0.0f, 1.0f);
        trianglePath.lineTo(0.866f, -0.5f);
        trianglePath.lineTo(-0.866f, -0.5f);
        trianglePath.lineTo(0.0f, 1.0f);
        at = new AffineTransform();
        at.translate(0.0, -0.25);
        at.scale(0.5, 0.5);
        trianglePath.transform(at);
        triangle = new ExplicitBoundsShape(trianglePath);
        ((ExplicitBoundsShape)triangle).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        GeneralPath arrowPath = new GeneralPath(0);
        arrowPath.moveTo(0.0f, -0.5f);
        arrowPath.lineTo(0.5f, 0.0f);
        arrowPath.lineTo(0.0f, 0.5f);
        arrowPath.lineTo(0.0f, 0.1f);
        arrowPath.lineTo(-0.5f, 0.1f);
        arrowPath.lineTo(-0.5f, -0.1f);
        arrowPath.lineTo(0.0f, -0.1f);
        arrowPath.lineTo(0.0f, -0.5f);
        arrow = new ExplicitBoundsShape(arrowPath);
        ((ExplicitBoundsShape)arrow).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        GeneralPath hatchPath = new GeneralPath(0);
        hatchPath.moveTo(0.55f, 0.57f);
        hatchPath.lineTo(0.52f, 0.57f);
        hatchPath.lineTo(-0.57f, -0.52f);
        hatchPath.lineTo(-0.57f, -0.57f);
        hatchPath.lineTo(-0.52f, -0.57f);
        hatchPath.lineTo(0.57f, 0.52f);
        hatchPath.lineTo(0.57f, 0.57f);
        hatchPath.moveTo(0.57f, -0.49f);
        hatchPath.lineTo(0.49f, -0.57f);
        hatchPath.lineTo(0.57f, -0.57f);
        hatchPath.lineTo(0.57f, -0.49f);
        hatchPath.moveTo(-0.57f, 0.5f);
        hatchPath.lineTo(-0.5f, 0.57f);
        hatchPath.lineTo(-0.57f, 0.57f);
        hatchPath.lineTo(-0.57f, 0.5f);
        hatch = new ExplicitBoundsShape(hatchPath);
        ((ExplicitBoundsShape)hatch).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        square = new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0);
    }
}

