/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class URConverterFactory
implements ConverterFactory {
    public static final Converter StringToURL = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            String s = (String)source;
            try {
                return (T)new URL(s);
            }
            catch (MalformedURLException e1) {
                File f = new File(s);
                try {
                    return (T)f.toURI().toURL();
                }
                catch (MalformedURLException e2) {
                    return null;
                }
            }
        }
    };
    public static final Converter StringToURI = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            String s = (String)source;
            try {
                return (T)new URI(s);
            }
            catch (URISyntaxException e1) {
                File f = new File(s);
                try {
                    return (T)f.toURI();
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
    };
    public static final Converter URLToURI = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            URL url = (URL)source;
            return (T)url.toURI();
        }
    };
    public static final Converter URIToURL = new Converter(){

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            URI uri = (URI)source;
            return (T)uri.toURL();
        }
    };

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (String.class.equals(source)) {
            if (URL.class.equals(target)) {
                return StringToURL;
            }
            if (URI.class.equals(target)) {
                return StringToURI;
            }
        }
        if (URL.class.equals(source) && URI.class.equals(target)) {
            return URLToURI;
        }
        if (URI.class.equals(source) && URL.class.equals(target)) {
            return URIToURL;
        }
        return null;
    }
}

