/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers.google;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.Config;
import org.mapfish.print.config.Key;
import org.mapfish.print.map.readers.google.GoogleURLSigner;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class GoogleConfig {
    private final Logger logger;
    public final String format;
    public final String sensor;
    public final String maptype;
    public final GoogleURLSigner signer;
    public final String language;
    public final List<String> markers;
    public final String path;

    public GoogleConfig(RenderingContext context, PJsonObject params, Logger logger, URI baseUrl, boolean requireKey) {
        this.format = params.getString("format");
        this.sensor = params.getString("sensor");
        this.maptype = params.getString("maptype");
        this.language = params.optString("language");
        this.path = this.addEscapes(params.optString("path"));
        this.markers = this.getList(params, "markers");
        this.signer = this.createUriSigner(context, baseUrl, requireKey);
        this.logger = logger;
    }

    private List<String> getList(PJsonObject params, String s) {
        List list;
        PJsonArray markerArray = params.optJSONArray(s);
        if (markerArray == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(markerArray.size());
            for (int i = 0; i < markerArray.size(); ++i) {
                String base = markerArray.getString(i);
                base = this.addEscapes(base);
                list.add(base);
            }
        }
        return Collections.unmodifiableList(list);
    }

    private String addEscapes(String base) {
        if (base != null) {
            return base;
        }
        return null;
    }

    private GoogleURLSigner createUriSigner(RenderingContext context, URI baseUrl, boolean requireKey) {
        GoogleURLSigner signer = null;
        Config config = context.getConfig();
        for (Key key : config.getKeys()) {
            try {
                URI localhostURI = new URI("http://" + InetAddress.getLocalHost().getHostName());
                if (key.getHost().validate(baseUrl)) {
                    if (key.getDomain().validate(localhostURI)) {
                        signer = new GoogleURLSigner(key);
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Failed domain matching: " + localhostURI + " to " + key.getDomain());
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Failed host matching: " + baseUrl + " to " + key.getHost());
            }
            catch (UnknownHostException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Failed host matching", e);
            }
            catch (SocketException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Failed host matching", e);
            }
            catch (MalformedURLException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Failed host matching", e);
            }
            catch (URISyntaxException e) {
                throw new Error(e);
            }
        }
        if (signer == null && requireKey) {
            throw new RuntimeException(baseUrl + " is a google layer and therefore it needs a key obtained from google so be usable in a non-webbrowser application.  Add a keys section to the config.yaml file or use TiledGoogle type instead. ");
        }
        return signer;
    }

    URI signURI(URI uri) throws UnsupportedEncodingException, URISyntaxException {
        try {
            String[] path = uri.toString().substring(uri.toString().indexOf(uri.getPath())).split("#", 2);
            String signedURI = uri.toString() + "&signature=" + this.signer.signature(path[0]);
            if (path.length > 1) {
                signedURI = signedURI + path[1];
            }
            return new URI(signedURI);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

