/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.map.renderers.vector.GeometriesRenderer;
import org.mapfish.print.utils.PJsonObject;

public class LabelRenderer {
    public static final Logger LOGGER = Logger.getLogger(LabelRenderer.class);

    static void applyStyle(RenderingContext context, PdfContentByte dc, PJsonObject style, Geometry geometry, AffineTransform affineTransform) {
        String label = style.optString("label");
        if (label != null && label.length() > 0) {
            String labelAlign = style.optString("labelAlign", "cm");
            float labelXOffset = style.optFloat("labelXOffset", 0.0f).floatValue();
            float labelYOffset = style.optFloat("labelYOffset", 0.0f).floatValue();
            float labelRotation = style.optFloat("labelRotation", 0.0f).floatValue();
            String fontColor = style.optString("fontColor", "#000000");
            String fontFamily = style.optString("fontFamily", "HELVETICA");
            String font = style.optString("font");
            String fontEncoding = style.optString("fontEncoding");
            if (font != null && !FontFactory.isRegistered(font)) {
                LOGGER.info("Font: '" + font + "' not registered, one of the supported fonts from 'fontFamily' will be used");
            } else if (!("COURIER".equalsIgnoreCase(fontFamily) || "HELVETICA".equalsIgnoreCase(fontFamily) || "TIMES_ROMAN".equalsIgnoreCase(fontFamily))) {
                LOGGER.info("Font family: '" + fontFamily + "' not supported, supported ones are 'HELVETICA', 'COURIER', 'TIMES_ROMAN', defaults to 'HELVETICA'");
                fontFamily = "HELVETICA";
            }
            String[] labels = label.split("\n");
            String fontSize = style.optString("fontSize", "12");
            String fontWeight = style.optString("fontWeight", "normal");
            Coordinate center = geometry.getCentroid().getCoordinate();
            center = GeometriesRenderer.transformCoordinate(center, affineTransform);
            float f = context.getStyleFactor();
            BaseFont bf = PDFUtils.getBaseFont(font, fontEncoding, fontFamily, fontSize, fontWeight);
            float fontHeight = (float)Double.parseDouble(fontSize.toLowerCase().replaceAll("px", "")) * f;
            dc.setFontAndSize(bf, fontHeight);
            dc.setColorFill(ColorWrapper.convertColor(fontColor));
            dc.beginText();
            dc.setTextMatrix((float)center.x + labelXOffset * f, (float)center.y + labelYOffset * f);
            for (int i = 0; i < labels.length; ++i) {
                dc.showTextAligned(PDFUtils.getHorizontalAlignment(labelAlign), labels[i], (float)center.x + labelXOffset * f, (float)center.y + labelYOffset * f - PDFUtils.getVerticalOffset(labelAlign, fontHeight) - (PDFUtils.getVerticalOffset(labelAlign, fontHeight) + 2.0f) * (float)i, labelRotation);
            }
            dc.endText();
        }
    }
}

