/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.idswitch.CodePrinter;
import org.mozilla.javascript.tools.idswitch.IdValuePair;

public class SwitchGenerator {
    String v_switch_label = "L0";
    String v_label = "L";
    String v_s = "s";
    String v_c = "c";
    String v_guess = "X";
    String v_id = "id";
    String v_length_suffix = "_length";
    int use_if_threshold = 3;
    int char_tail_test_threshold = 2;
    private IdValuePair[] pairs;
    private String default_value;
    private int[] columns;
    private boolean c_was_defined;
    private CodePrinter P;
    private ToolErrorReporter R;
    private String source_file;

    public CodePrinter getCodePrinter() {
        return this.P;
    }

    public void setCodePrinter(CodePrinter codePrinter) {
        this.P = codePrinter;
    }

    public ToolErrorReporter getReporter() {
        return this.R;
    }

    public void setReporter(ToolErrorReporter toolErrorReporter) {
        this.R = toolErrorReporter;
    }

    public String getSourceFileName() {
        return this.source_file;
    }

    public void setSourceFileName(String string) {
        this.source_file = string;
    }

    public void generateSwitch(String[] stringArray, String string) {
        int n = stringArray.length / 2;
        IdValuePair[] idValuePairArray = new IdValuePair[n];
        for (int i = 0; i != n; ++i) {
            idValuePairArray[i] = new IdValuePair(stringArray[2 * i], stringArray[2 * i + 1]);
        }
        this.generateSwitch(idValuePairArray, string);
    }

    public void generateSwitch(IdValuePair[] idValuePairArray, String string) {
        int n = 0;
        int n2 = idValuePairArray.length;
        if (n == n2) {
            return;
        }
        this.pairs = idValuePairArray;
        this.default_value = string;
        this.generate_body(n, n2, 2);
    }

    private void generate_body(int n, int n2, int n3) {
        this.P.indent(n3);
        this.P.p(this.v_switch_label);
        this.P.p(": { ");
        this.P.p(this.v_id);
        this.P.p(" = ");
        this.P.p(this.default_value);
        this.P.p("; String ");
        this.P.p(this.v_guess);
        this.P.p(" = null;");
        this.c_was_defined = false;
        int n4 = this.P.getOffset();
        this.P.p(" int ");
        this.P.p(this.v_c);
        this.P.p(';');
        int n5 = this.P.getOffset();
        this.P.nl();
        this.generate_length_switch(n, n2, n3 + 1);
        if (!this.c_was_defined) {
            this.P.erase(n4, n5);
        }
        this.P.indent(n3 + 1);
        this.P.p("if (");
        this.P.p(this.v_guess);
        this.P.p("!=null && ");
        this.P.p(this.v_guess);
        this.P.p("!=");
        this.P.p(this.v_s);
        this.P.p(" && !");
        this.P.p(this.v_guess);
        this.P.p(".equals(");
        this.P.p(this.v_s);
        this.P.p(")) ");
        this.P.p(this.v_id);
        this.P.p(" = ");
        this.P.p(this.default_value);
        this.P.p(";");
        this.P.nl();
        this.P.line(n3, "}");
    }

    private void generate_length_switch(int n, int n2, int n3) {
        boolean bl;
        this.sort_pairs(n, n2, -1);
        this.check_all_is_different(n, n2);
        int n4 = this.count_different_lengths(n, n2);
        this.columns = new int[this.pairs[n2 - 1].idLength];
        if (n4 <= this.use_if_threshold) {
            bl = true;
            if (n4 != 1) {
                this.P.indent(n3);
                this.P.p("int ");
                this.P.p(this.v_s);
                this.P.p(this.v_length_suffix);
                this.P.p(" = ");
                this.P.p(this.v_s);
                this.P.p(".length();");
                this.P.nl();
            }
        } else {
            bl = false;
            this.P.indent(n3);
            this.P.p(this.v_label);
            this.P.p(": switch (");
            this.P.p(this.v_s);
            this.P.p(".length()) {");
            this.P.nl();
        }
        int n5 = n;
        int n6 = this.pairs[n].idLength;
        int n7 = 0;
        int n8 = n;
        while (true) {
            int n9;
            if (++n8 != n2 && (n7 = this.pairs[n8].idLength) == n6) {
                continue;
            }
            if (bl) {
                this.P.indent(n3);
                if (n5 != n) {
                    this.P.p("else ");
                }
                this.P.p("if (");
                if (n4 == 1) {
                    this.P.p(this.v_s);
                    this.P.p(".length()==");
                } else {
                    this.P.p(this.v_s);
                    this.P.p(this.v_length_suffix);
                    this.P.p("==");
                }
                this.P.p(n6);
                this.P.p(") {");
                n9 = n3 + 1;
            } else {
                this.P.indent(n3);
                this.P.p("case ");
                this.P.p(n6);
                this.P.p(":");
                n9 = n3 + 1;
            }
            this.generate_letter_switch(n5, n8, n9, !bl, bl);
            if (bl) {
                this.P.p("}");
                this.P.nl();
            } else {
                this.P.p("break ");
                this.P.p(this.v_label);
                this.P.p(";");
                this.P.nl();
            }
            if (n8 == n2) break;
            n5 = n8;
            n6 = n7;
        }
        if (!bl) {
            this.P.indent(n3);
            this.P.p("}");
            this.P.nl();
        }
    }

    private void generate_letter_switch(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = this.pairs[n].idLength;
        for (int i = 0; i != n4; ++i) {
            this.columns[i] = i;
        }
        this.generate_letter_switch_r(n, n2, n4, n3, bl, bl2);
    }

    private boolean generate_letter_switch_r(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = false;
        if (n + 1 == n2) {
            this.P.p(' ');
            IdValuePair idValuePair = this.pairs[n];
            if (n3 > this.char_tail_test_threshold) {
                this.P.p(this.v_guess);
                this.P.p("=");
                this.P.qstring(idValuePair.id);
                this.P.p(";");
                this.P.p(this.v_id);
                this.P.p("=");
                this.P.p(idValuePair.value);
                this.P.p(";");
            } else if (n3 == 0) {
                bl4 = true;
                this.P.p(this.v_id);
                this.P.p("=");
                this.P.p(idValuePair.value);
                this.P.p("; break ");
                this.P.p(this.v_switch_label);
                this.P.p(";");
            } else {
                this.P.p("if (");
                int n5 = this.columns[0];
                this.P.p(this.v_s);
                this.P.p(".charAt(");
                this.P.p(n5);
                this.P.p(")==");
                this.P.qchar(idValuePair.id.charAt(n5));
                for (int i = 1; i != n3; ++i) {
                    this.P.p(" && ");
                    n5 = this.columns[i];
                    this.P.p(this.v_s);
                    this.P.p(".charAt(");
                    this.P.p(n5);
                    this.P.p(")==");
                    this.P.qchar(idValuePair.id.charAt(n5));
                }
                this.P.p(") {");
                this.P.p(this.v_id);
                this.P.p("=");
                this.P.p(idValuePair.value);
                this.P.p("; break ");
                this.P.p(this.v_switch_label);
                this.P.p(";}");
            }
            this.P.p(' ');
            return bl4;
        }
        int n6 = this.find_max_different_column(n, n2, n3);
        int n7 = this.columns[n6];
        int n8 = this.count_different_chars(n, n2, n7);
        this.columns[n6] = this.columns[n3 - 1];
        if (bl2) {
            this.P.nl();
            this.P.indent(n4);
        } else {
            this.P.p(' ');
        }
        if (n8 <= this.use_if_threshold) {
            bl3 = true;
            this.c_was_defined = true;
            this.P.p(this.v_c);
            this.P.p("=");
            this.P.p(this.v_s);
            this.P.p(".charAt(");
            this.P.p(n7);
            this.P.p(");");
        } else {
            bl3 = false;
            if (!bl) {
                bl = true;
                this.P.p(this.v_label);
                this.P.p(": ");
            }
            this.P.p("switch (");
            this.P.p(this.v_s);
            this.P.p(".charAt(");
            this.P.p(n7);
            this.P.p(")) {");
        }
        int n9 = n;
        char c = this.pairs[n].id.charAt(n7);
        char c2 = '\u0000';
        int n10 = n;
        while (true) {
            int n11;
            if (++n10 != n2 && (c2 = this.pairs[n10].id.charAt(n7)) == c) {
                continue;
            }
            if (bl3) {
                this.P.nl();
                this.P.indent(n4);
                if (n9 != n) {
                    this.P.p("else ");
                }
                this.P.p("if (");
                this.P.p(this.v_c);
                this.P.p("==");
                this.P.qchar(c);
                this.P.p(") {");
                n11 = n4 + 1;
            } else {
                this.P.nl();
                this.P.indent(n4);
                this.P.p("case ");
                this.P.qchar(c);
                this.P.p(":");
                n11 = n4 + 1;
            }
            boolean bl5 = this.generate_letter_switch_r(n9, n10, n3 - 1, n11, bl, bl3);
            if (bl3) {
                this.P.p("}");
            } else if (!bl5) {
                this.P.p("break ");
                this.P.p(this.v_label);
                this.P.p(";");
            }
            if (n10 == n2) break;
            n9 = n10;
            c = c2;
        }
        if (bl3) {
            this.P.nl();
            if (bl2) {
                this.P.indent(n4 - 1);
            } else {
                this.P.indent(n4);
            }
        } else {
            this.P.nl();
            this.P.indent(n4);
            this.P.p("}");
            if (bl2) {
                this.P.nl();
                this.P.indent(n4 - 1);
            } else {
                this.P.p(' ');
            }
        }
        this.columns[n6] = n7;
        return bl4;
    }

    private int count_different_lengths(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        while (n != n2) {
            int n5 = this.pairs[n].idLength;
            if (n4 != n5) {
                ++n3;
                n4 = n5;
            }
            ++n;
        }
        return n3;
    }

    private int find_max_different_column(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i != n3; ++i) {
            int n6 = this.columns[i];
            this.sort_pairs(n, n2, n6);
            int n7 = this.count_different_chars(n, n2, n6);
            if (n7 == n2 - n) {
                return i;
            }
            if (n4 >= n7) continue;
            n4 = n7;
            n5 = i;
        }
        if (n5 != n3 - 1) {
            this.sort_pairs(n, n2, this.columns[n5]);
        }
        return n5;
    }

    private int count_different_chars(int n, int n2, int n3) {
        int n4 = 0;
        int c = -1;
        while (n != n2) {
            char c2;
            char c3 = this.pairs[n].id.charAt(n3);
            if (c3 != c2) {
                ++n4;
                c2 = c3;
            }
            ++n;
        }
        return n4;
    }

    private void check_all_is_different(int n, int n2) {
        if (n != n2) {
            IdValuePair idValuePair = this.pairs[n];
            while (++n != n2) {
                IdValuePair idValuePair2 = this.pairs[n];
                if (idValuePair.id.equals(idValuePair2.id)) {
                    throw this.on_same_pair_fail(idValuePair, idValuePair2);
                }
                idValuePair = idValuePair2;
            }
        }
    }

    private EvaluatorException on_same_pair_fail(IdValuePair idValuePair, IdValuePair idValuePair2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = idValuePair.getLineNumber();
        int n2 = idValuePair2.getLineNumber();
        if (n2 > n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        String string = ToolErrorReporter.getMessage("msg.idswitch.same_string", idValuePair.id, new Integer(n2));
        return this.R.runtimeError(string, this.source_file, n, null, 0);
    }

    private void sort_pairs(int n, int n2, int n3) {
        SwitchGenerator.heap4Sort(this.pairs, n, n2 - n, n3);
    }

    private static boolean bigger(IdValuePair idValuePair, IdValuePair idValuePair2, int n) {
        if (n < 0) {
            int n2 = idValuePair.idLength - idValuePair2.idLength;
            if (n2 != 0) {
                return n2 > 0;
            }
            return idValuePair.id.compareTo(idValuePair2.id) > 0;
        }
        return idValuePair.id.charAt(n) > idValuePair2.id.charAt(n);
    }

    private static void heap4Sort(IdValuePair[] idValuePairArray, int n, int n2, int n3) {
        if (n2 <= 1) {
            return;
        }
        SwitchGenerator.makeHeap4(idValuePairArray, n, n2, n3);
        while (n2 > 1) {
            IdValuePair idValuePair;
            IdValuePair idValuePair2 = idValuePairArray[n + --n2];
            idValuePairArray[n + n2] = idValuePair = idValuePairArray[n + 0];
            idValuePairArray[n + 0] = idValuePair2;
            SwitchGenerator.heapify4(idValuePairArray, n, n2, 0, n3);
        }
    }

    private static void makeHeap4(IdValuePair[] idValuePairArray, int n, int n2, int n3) {
        int n4 = n2 + 2 >> 2;
        while (n4 != 0) {
            SwitchGenerator.heapify4(idValuePairArray, n, n2, --n4, n3);
        }
    }

    private static void heapify4(IdValuePair[] idValuePairArray, int n, int n2, int n3, int n4) {
        IdValuePair idValuePair;
        int n5;
        int n6;
        int n7;
        IdValuePair idValuePair2 = idValuePairArray[n + n3];
        while (true) {
            int n8 = n3 << 2;
            n7 = n8 | 1;
            n6 = n8 | 2;
            n5 = n8 | 3;
            int n9 = n8 + 4;
            if (n9 >= n2) break;
            idValuePair = idValuePairArray[n + n7];
            IdValuePair idValuePair3 = idValuePairArray[n + n6];
            IdValuePair idValuePair4 = idValuePairArray[n + n5];
            IdValuePair idValuePair5 = idValuePairArray[n + n9];
            if (SwitchGenerator.bigger(idValuePair3, idValuePair, n4)) {
                idValuePair = idValuePair3;
                n7 = n6;
            }
            if (SwitchGenerator.bigger(idValuePair5, idValuePair4, n4)) {
                idValuePair4 = idValuePair5;
                n5 = n9;
            }
            if (SwitchGenerator.bigger(idValuePair4, idValuePair, n4)) {
                idValuePair = idValuePair4;
                n7 = n5;
            }
            if (SwitchGenerator.bigger(idValuePair2, idValuePair, n4)) {
                return;
            }
            idValuePairArray[n + n3] = idValuePair;
            idValuePairArray[n + n7] = idValuePair2;
            n3 = n7;
        }
        if (n7 < n2) {
            IdValuePair idValuePair6 = idValuePairArray[n + n7];
            if (n6 != n2) {
                IdValuePair idValuePair7 = idValuePairArray[n + n6];
                if (SwitchGenerator.bigger(idValuePair7, idValuePair6, n4)) {
                    idValuePair6 = idValuePair7;
                    n7 = n6;
                }
                if (n5 != n2 && SwitchGenerator.bigger(idValuePair = idValuePairArray[n + n5], idValuePair6, n4)) {
                    idValuePair6 = idValuePair;
                    n7 = n5;
                }
            }
            if (SwitchGenerator.bigger(idValuePair6, idValuePair2, n4)) {
                idValuePairArray[n + n3] = idValuePair6;
                idValuePairArray[n + n7] = idValuePair2;
            }
        }
    }
}

