/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodReturnValueHandlerComposite
implements HandlerMethodReturnValueHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
    private final Map<MethodParameter, HandlerMethodReturnValueHandler> returnValueHandlerCache = new ConcurrentHashMap<MethodParameter, HandlerMethodReturnValueHandler>();

    public List<HandlerMethodReturnValueHandler> getHandlers() {
        return Collections.unmodifiableList(this.returnValueHandlers);
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType2) {
        return this.getReturnValueHandler(returnType2) != null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType2, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType2);
        Assert.notNull(handler, "Unknown return value type [" + returnType2.getParameterType().getName() + "]");
        handler.handleReturnValue(returnValue, returnType2, mavContainer, webRequest);
    }

    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType2) {
        HandlerMethodReturnValueHandler result = this.returnValueHandlerCache.get(returnType2);
        if (result == null) {
            for (HandlerMethodReturnValueHandler returnValueHandler : this.returnValueHandlers) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Testing if return value handler [" + returnValueHandler + "] supports [" + returnType2.getGenericParameterType() + "]");
                }
                if (!returnValueHandler.supportsReturnType(returnType2)) continue;
                result = returnValueHandler;
                this.returnValueHandlerCache.put(returnType2, returnValueHandler);
                break;
            }
        }
        return result;
    }

    public HandlerMethodReturnValueHandlerComposite addHandler(HandlerMethodReturnValueHandler returnValuehandler) {
        this.returnValueHandlers.add(returnValuehandler);
        return this;
    }

    public HandlerMethodReturnValueHandlerComposite addHandlers(List<? extends HandlerMethodReturnValueHandler> returnValueHandlers) {
        if (returnValueHandlers != null) {
            for (HandlerMethodReturnValueHandler handlerMethodReturnValueHandler : returnValueHandlers) {
                this.returnValueHandlers.add(handlerMethodReturnValueHandler);
            }
        }
        return this;
    }
}

