/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class NamespaceUtil {
    private List<NamespaceInfo> infos = new ArrayList<NamespaceInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceUtil() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("/META-INF/membrane.namespaces");
            while (resources.hasMoreElements()) {
                String key;
                URL url = resources.nextElement();
                Properties p = new Properties();
                try (InputStream s = url.openStream();){
                    p.load(s);
                }
                int i = 1;
                while (p.containsKey((key = "schema" + i++) + "-targetNamespace")) {
                    String targetNamespace = p.getProperty(key + "-targetNamespace");
                    String outputName = p.getProperty(key + "-outputName");
                    String outputPackage = p.getProperty(key + "-outputPackage");
                    this.infos.add(new NamespaceInfo(targetNamespace, outputName, outputPackage));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getTargetNamespaces() {
        ArrayList<String> res = new ArrayList<String>();
        for (NamespaceInfo ni : this.infos) {
            res.add(ni.getTargetNamespace());
        }
        return res;
    }

    private NamespaceInfo getInfo(String targetNamespace) {
        for (NamespaceInfo ni : this.infos) {
            if (!ni.getTargetNamespace().equals(targetNamespace)) continue;
            return ni;
        }
        throw new InvalidParameterException("targetNamespace '" + targetNamespace + "' not defined.");
    }

    public String getOutputName(String targetNamespace) {
        return this.getInfo(targetNamespace).getOutputName();
    }

    public String getOutputPackage(String targetNamespace) {
        return this.getInfo(targetNamespace).getOutputPackage();
    }

    private static class NamespaceInfo {
        private final String targetNamespace;
        private final String outputName;
        private final String outputPackage;

        public NamespaceInfo(String targetNamespace, String outputName, String outputPackage) {
            this.targetNamespace = targetNamespace;
            this.outputName = outputName;
            this.outputPackage = outputPackage;
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public String getOutputPackage() {
            return this.outputPackage;
        }
    }
}

