/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot;

import com.predic8.membrane.annot.AnnotUtils;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCMain;
import com.predic8.membrane.annot.MCOtherAttributes;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.annot.ProcessingException;
import com.predic8.membrane.annot.generator.BlueprintParsers;
import com.predic8.membrane.annot.generator.HelpReference;
import com.predic8.membrane.annot.generator.NamespaceInfo;
import com.predic8.membrane.annot.generator.Parsers;
import com.predic8.membrane.annot.generator.Schemas;
import com.predic8.membrane.annot.model.AttributeInfo;
import com.predic8.membrane.annot.model.ChildElementDeclarationInfo;
import com.predic8.membrane.annot.model.ChildElementInfo;
import com.predic8.membrane.annot.model.ElementInfo;
import com.predic8.membrane.annot.model.MainInfo;
import com.predic8.membrane.annot.model.Model;
import com.predic8.membrane.annot.model.OtherAttributesInfo;
import com.predic8.membrane.annot.model.TextContentInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.predic8.membrane.annot.*"})
public class SpringConfigurationXSDGeneratingAnnotationProcessor
extends AbstractProcessor {
    private static final String CACHE_FILE_FORMAT_VERSION = "1";
    private HashMap<Class<? extends Annotation>, HashSet<Element>> cache;
    boolean done;
    private static final String REQUIRED = "org.springframework.beans.factory.annotation.Required";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void log(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        if (this.cache != null) {
            return;
        }
        this.cache = new HashMap();
        try {
            FileObject o = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/membrane.cache");
            try (BufferedReader bufferedReader = new BufferedReader(o.openReader(false));){
                String line;
                if (!CACHE_FILE_FORMAT_VERSION.equals(bufferedReader.readLine())) {
                    return;
                }
                HashSet<TypeElement> currentSet = null;
                Class<?> annotationClass = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.startsWith(" ")) {
                        line = line.substring(1);
                        TypeElement element = null;
                        try {
                            element = this.processingEnv.getElementUtils().getTypeElement(line);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        if (element == null || element.getAnnotation(annotationClass) == null) continue;
                        currentSet.add(element);
                        continue;
                    }
                    try {
                        annotationClass = this.getClass().getClassLoader().loadClass(line);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    currentSet = new HashSet<TypeElement>();
                    this.cache.put(annotationClass, currentSet);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Set set : this.cache.values()) {
            String status = "read " + set.size();
            this.log(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        try {
            FileObject o = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/membrane.cache", new Element[0]);
            try (BufferedWriter bw = new BufferedWriter(o.openWriter());){
                bw.write("1\n");
                for (Map.Entry<Class<? extends Annotation>, HashSet<Element>> e : this.cache.entrySet()) {
                    bw.write(e.getKey().getName());
                    bw.write("\n");
                    for (Element f : e.getValue()) {
                        bw.write(" ");
                        bw.write(((TypeElement)f).getQualifiedName().toString());
                        bw.write("\n");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<? extends Element> getCachedElementsAnnotatedWith(RoundEnvironment roundEnv, Class<? extends Annotation> annotation) {
        HashSet<Element> result;
        if (this.cache == null) {
            this.read();
        }
        if ((result = this.cache.get(annotation)) == null) {
            result = new HashSet<Element>(roundEnv.getElementsAnnotatedWith(annotation));
            this.cache.put(annotation, result);
        } else {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotation)) {
                result.remove(element);
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            String status = "process() a=" + annotations.size() + " r=" + roundEnv.getRootElements().size() + " h=" + this.hashCode() + (roundEnv.processingOver() ? " processing-over" : " ");
            this.log(status);
            this.read();
            if (roundEnv.processingOver()) {
                this.write();
            }
            if (annotations.size() > 0) {
                status = "working with " + this.getCachedElementsAnnotatedWith(roundEnv, MCMain.class).size() + " and " + this.getCachedElementsAnnotatedWith(roundEnv, MCElement.class).size();
                this.log(status);
                Model m = new Model();
                Set<? extends Element> mcmains = this.getCachedElementsAnnotatedWith(roundEnv, MCMain.class);
                if (mcmains.isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "@MCMain was nowhere found.");
                    return true;
                }
                for (Element element : mcmains) {
                    MainInfo main = new MainInfo();
                    main.setElement((TypeElement)element);
                    main.setAnnotation(element.getAnnotation(MCMain.class));
                    m.getMains().add(main);
                }
                for (Element element : this.getCachedElementsAnnotatedWith(roundEnv, MCElement.class)) {
                    ElementInfo ii = new ElementInfo();
                    ii.setElement((TypeElement)element);
                    ii.setAnnotation(element.getAnnotation(MCElement.class));
                    MainInfo main = ii.getMain(m);
                    main.getIis().add(ii);
                    main.getElements().put(ii.getElement(), ii);
                    if (main.getGlobals().containsKey(ii.getAnnotation().name())) {
                        throw new ProcessingException("Duplicate global @MCElement name.", main.getGlobals().get(ii.getAnnotation().name()).getElement(), ii.getElement());
                    }
                    if (main.getIds().containsKey(ii.getId())) {
                        throw new ProcessingException("Duplicate element id \"" + ii.getId() + "\". Please assign one using @MCElement(id=\"...\").", element, main.getIds().get(ii.getId()).getElement());
                    }
                    main.getIds().put(ii.getId(), ii);
                    this.scan(m, main, ii);
                    if (ii.getTci() != null && !ii.getAnnotation().mixed()) {
                        throw new ProcessingException("@MCTextContent requires @MCElement(..., mixed=true) on the class.", ii.getElement());
                    }
                    if (ii.getTci() != null || !ii.getAnnotation().mixed()) continue;
                    throw new ProcessingException("@MCElement(..., mixed=true) requires @MCTextContent on a property.", ii.getElement());
                }
                for (MainInfo mainInfo : m.getMains()) {
                    for (Map.Entry<TypeElement, ChildElementDeclarationInfo> f : mainInfo.getChildElementDeclarations().entrySet()) {
                        ChildElementDeclarationInfo cedi = f.getValue();
                        ElementInfo ei = mainInfo.getElements().get(f.getKey());
                        if (ei != null) {
                            cedi.getElementInfo().add(ei);
                        } else {
                            for (Map.Entry<TypeElement, ElementInfo> e : mainInfo.getElements().entrySet()) {
                                if (!this.processingEnv.getTypeUtils().isAssignable(e.getKey().asType(), f.getKey().asType())) continue;
                                cedi.getElementInfo().add(e.getValue());
                            }
                        }
                        for (ElementInfo ei2 : cedi.getElementInfo()) {
                            ei2.addUsedBy(f.getValue());
                        }
                        if (!cedi.getElementInfo().isEmpty() || !cedi.isRaiseErrorWhenNoSpecimen()) continue;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@MCChildElement references " + f.getKey().getQualifiedName() + ", but there is no @MCElement among it and its subclasses.", f.getKey());
                        return true;
                    }
                }
                if (mcmains.isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@MCMain but no @MCElement found.", mcmains.iterator().next());
                    return true;
                }
                this.process(m);
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessingException e1) {
            for (int i = 0; i < e1.getElements().length; ++i) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, i == 0 ? e1.getMessage() : "also here", e1.getElements()[i]);
            }
            return true;
        }
    }

    private void scan(Model m, MainInfo main, ElementInfo ii) {
        this.scan(m, main, ii, ii.getElement());
    }

    private void scan(Model m, MainInfo main, ElementInfo ii, TypeElement te) {
        TypeMirror superclass = te.getSuperclass();
        if (superclass instanceof DeclaredType) {
            this.scan(m, main, ii, (TypeElement)((DeclaredType)superclass).asElement());
        }
        for (Element element : te.getEnclosedElements()) {
            MCTextContent c;
            MCChildElement b;
            MCOtherAttributes d;
            MCAttribute a = element.getAnnotation(MCAttribute.class);
            if (a != null) {
                AttributeInfo ai = new AttributeInfo();
                ai.setAnnotation(a);
                ai.setE((ExecutableElement)element);
                ai.setRequired(this.isRequired(element));
                ii.getAis().add(ai);
                ii.setHasIdField(ii.isHasIdField() || ai.getXMLName().equals("id"));
            }
            if ((d = element.getAnnotation(MCOtherAttributes.class)) != null) {
                OtherAttributesInfo oai = new OtherAttributesInfo();
                oai.setOtherAttributesSetter((ExecutableElement)element);
                ii.setOai(oai);
            }
            if ((b = element.getAnnotation(MCChildElement.class)) != null) {
                ChildElementDeclarationInfo cedi;
                ChildElementInfo cei = new ChildElementInfo();
                cei.setEi(ii);
                cei.setAnnotation(b);
                cei.setE((ExecutableElement)element);
                List<? extends VariableElement> parameters = cei.getE().getParameters();
                if (parameters.size() == 0) {
                    throw new ProcessingException("Setter must have exactly one parameter.", element);
                }
                TypeMirror setterArgType = parameters.get(0).asType();
                if (!(setterArgType instanceof DeclaredType)) {
                    throw new ProcessingException("Setter argument must be of an @MCElement-annotated type.", parameters.get(0));
                }
                cei.setTypeDeclaration((TypeElement)((DeclaredType)setterArgType).asElement());
                cei.setPropertyName(AnnotUtils.dejavaify(element.getSimpleName().toString().substring(3)));
                cei.setRequired(this.isRequired(element));
                ii.getCeis().add(cei);
                if (cei.getTypeDeclaration().getQualifiedName().toString().startsWith("java.util.List") || cei.getTypeDeclaration().getQualifiedName().toString().startsWith("java.util.Collection")) {
                    cei.setTypeDeclaration((TypeElement)((DeclaredType)((DeclaredType)setterArgType).getTypeArguments().get(0)).asElement());
                    cei.setList(true);
                }
                if (!main.getChildElementDeclarations().containsKey(cei.getTypeDeclaration())) {
                    cedi = new ChildElementDeclarationInfo();
                    cedi.setTarget(cei.getTypeDeclaration());
                    cedi.setRaiseErrorWhenNoSpecimen(!cei.getAnnotation().allowForeign());
                    main.getChildElementDeclarations().put(cei.getTypeDeclaration(), cedi);
                } else {
                    cedi.setRaiseErrorWhenNoSpecimen((cedi = main.getChildElementDeclarations().get(cei.getTypeDeclaration())).isRaiseErrorWhenNoSpecimen() || !cei.getAnnotation().allowForeign());
                }
                cedi.addUsedBy(cei);
            }
            if ((c = element.getAnnotation(MCTextContent.class)) == null) continue;
            TextContentInfo tci = new TextContentInfo();
            tci.setPropertyName(AnnotUtils.dejavaify(element.getSimpleName().toString().substring(3)));
            ii.setTci(tci);
        }
        HashSet<Integer> childOrders = new HashSet<Integer>();
        for (ChildElementInfo cei : ii.getCeis()) {
            if (childOrders.add(cei.getAnnotation().order())) continue;
            throw new ProcessingException("@MCChildElement(order=...) must be unique.", cei.getE());
        }
        Collections.sort(ii.getCeis());
    }

    private boolean isRequired(Element e2) {
        for (AnnotationMirror annotationMirror : e2.getAnnotationMirrors()) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(REQUIRED)) continue;
            return true;
        }
        return false;
    }

    public void process(Model m) throws IOException {
        new Schemas(this.processingEnv).writeXSD(m);
        new Parsers(this.processingEnv).writeParsers(m);
        new Parsers(this.processingEnv).writeParserDefinitior(m);
        new HelpReference(this.processingEnv).writeHelp(m);
        new NamespaceInfo(this.processingEnv).writeInfo(m);
        if (this.processingEnv.getElementUtils().getTypeElement("org.apache.aries.blueprint.ParserContext") != null) {
            new BlueprintParsers(this.processingEnv).writeParserDefinitior(m);
            new BlueprintParsers(this.processingEnv).writeParsers(m);
        }
    }
}

