/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot.bean;

import com.predic8.membrane.annot.AnnotUtils;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCOtherAttributes;
import com.predic8.membrane.annot.MCTextContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MCUtil {
    private static XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();

    private static <T> T cloneInternal(T object, boolean deep) {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            ArrayList res = new ArrayList(((Collection)object).size());
            for (Object item : (Collection)object) {
                res.add(deep ? MCUtil.cloneInternal(item, deep) : item);
            }
            return (T)res;
        }
        return MCUtil.clone(object, deep);
    }

    public static <T> T clone(T object, boolean deep) {
        try {
            if (object == null) {
                throw new InvalidParameterException("'object' must not be null.");
            }
            Class<?> clazz = object.getClass();
            MCElement e = clazz.getAnnotation(MCElement.class);
            if (e == null) {
                throw new IllegalArgumentException("'object' must be @MCElement-annotated.");
            }
            BeanWrapperImpl dst = new BeanWrapperImpl(clazz);
            BeanWrapperImpl src = new BeanWrapperImpl(object);
            for (Method m : clazz.getMethods()) {
                MCTextContent t;
                MCOtherAttributes o;
                MCChildElement c;
                if (!m.getName().startsWith("set")) continue;
                String propertyName = AnnotUtils.dejavaify(m.getName().substring(3));
                MCAttribute a = m.getAnnotation(MCAttribute.class);
                if (a != null) {
                    dst.setPropertyValue(propertyName, src.getPropertyValue(propertyName));
                }
                if ((c = m.getAnnotation(MCChildElement.class)) != null) {
                    if (deep) {
                        dst.setPropertyValue(propertyName, MCUtil.cloneInternal(src.getPropertyValue(propertyName), deep));
                    } else {
                        dst.setPropertyValue(propertyName, src.getPropertyValue(propertyName));
                    }
                }
                if ((o = m.getAnnotation(MCOtherAttributes.class)) != null) {
                    dst.setPropertyValue(propertyName, src.getPropertyValue(propertyName));
                }
                if ((t = m.getAnnotation(MCTextContent.class)) == null) continue;
                dst.setPropertyValue(propertyName, src.getPropertyValue(propertyName));
            }
            return (T)dst.getRootInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromXML(Class<T> clazz, String xml) {
        String MAGIC = "magic.xml";
        FileSystemXmlApplicationContextExtension fsxacApplicationContext = new FileSystemXmlApplicationContextExtension("magic.xml", xml);
        fsxacApplicationContext.setConfigLocation("magic.xml");
        try {
            fsxacApplicationContext.refresh();
        }
        catch (RuntimeException e) {
            System.err.println(xml);
            throw e;
        }
        Object bean = null;
        if (fsxacApplicationContext.containsBean("main")) {
            bean = fsxacApplicationContext.getBean("main");
        } else {
            Collection beans = fsxacApplicationContext.getBeansOfType(clazz).values();
            if (beans.size() > 1) {
                throw new InvalidParameterException("There is more than one bean of type '" + clazz.getName() + "'.");
            }
            bean = beans.iterator().next();
        }
        if (bean == null) {
            throw new InvalidParameterException("Did not find bean with ID 'main'.");
        }
        if (!clazz.isAssignableFrom(bean.getClass())) {
            throw new InvalidParameterException("Bean 'main' is not a " + clazz.getName() + " .");
        }
        return (T)bean;
    }

    private static void addXML(Object object, String id, XMLStreamWriter xew, SerializationContext sc) throws XMLStreamException {
        Object value;
        String propertyName;
        if (object == null) {
            throw new InvalidParameterException("'object' must not be null.");
        }
        Class<?> clazz = object.getClass();
        MCElement e = clazz.getAnnotation(MCElement.class);
        if (e == null) {
            throw new IllegalArgumentException("'object' must be @MCElement-annotated.");
        }
        BeanWrapperImpl src = new BeanWrapperImpl(object);
        xew.writeStartElement(e.name());
        if (id != null) {
            xew.writeAttribute("id", id);
        }
        HashSet<String> attributes = new HashSet<String>();
        for (Method m : clazz.getMethods()) {
            String str;
            if (!m.getName().startsWith("set")) continue;
            propertyName = AnnotUtils.dejavaify(m.getName().substring(3));
            MCAttribute a = m.getAnnotation(MCAttribute.class);
            if (a == null || (value = src.getPropertyValue(propertyName)) == null) continue;
            if (value instanceof String) {
                str = (String)value;
            } else if (value instanceof Boolean) {
                str = ((Boolean)value).toString();
            } else if (value instanceof Integer) {
                str = ((Integer)value).toString();
            } else if (value instanceof Long) {
                str = ((Long)value).toString();
            } else if (value instanceof Enum) {
                str = value.toString();
            } else {
                MCElement el = value.getClass().getAnnotation(MCElement.class);
                if (el != null) {
                    str = MCUtil.defineBean(sc, value, null, true);
                } else {
                    str = "?";
                    sc.incomplete = true;
                }
            }
            if (a.attributeName().length() > 0) {
                propertyName = a.attributeName();
            }
            attributes.add(propertyName);
            xew.writeAttribute(propertyName, str);
        }
        for (Method m : clazz.getMethods()) {
            if (!m.getName().startsWith("set")) continue;
            propertyName = AnnotUtils.dejavaify(m.getName().substring(3));
            MCOtherAttributes o = m.getAnnotation(MCOtherAttributes.class);
            if (o == null) continue;
            value = src.getPropertyValue(propertyName);
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (!(key instanceof String) || !(val instanceof String)) {
                        sc.incomplete = true;
                        key = "incompleteAttributes";
                        val = "?";
                    }
                    if (attributes.contains(key)) continue;
                    attributes.add((String)key);
                    xew.writeAttribute((String)key, (String)val);
                }
                continue;
            }
            xew.writeAttribute("incompleteAttributes", "?");
            sc.incomplete = true;
        }
        ArrayList<Method> childElements = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            Object value2;
            MCTextContent t;
            if (!m.getName().startsWith("set")) continue;
            String propertyName2 = AnnotUtils.dejavaify(m.getName().substring(3));
            MCChildElement c = m.getAnnotation(MCChildElement.class);
            if (c != null) {
                childElements.add(m);
            }
            if ((t = m.getAnnotation(MCTextContent.class)) == null || (value2 = src.getPropertyValue(propertyName2)) == null) continue;
            if (value2 instanceof String) {
                xew.writeCharacters((String)value2);
                continue;
            }
            xew.writeCharacters("?");
            sc.incomplete = true;
        }
        Collections.sort(childElements, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                MCChildElement c1 = o1.getAnnotation(MCChildElement.class);
                MCChildElement c2 = o2.getAnnotation(MCChildElement.class);
                return c1.order() - c2.order();
            }
        });
        for (Method m : childElements) {
            String propertyName3 = AnnotUtils.dejavaify(m.getName().substring(3));
            Object value3 = src.getPropertyValue(propertyName3);
            if (value3 == null) continue;
            if (value3 instanceof Collection) {
                for (Object item : (Collection)value3) {
                    MCUtil.addXML(item, null, xew, sc);
                }
                continue;
            }
            MCUtil.addXML(value3, null, xew, sc);
        }
        xew.writeEndElement();
    }

    private static String defineBean(SerializationContext sc, Object object, String idSuggestion, boolean requireBeanId) throws XMLStreamException {
        if (sc.ids.containsKey(object)) {
            return sc.ids.get(object);
        }
        String id = idSuggestion;
        if (requireBeanId && id == null) {
            id = "bean" + sc.nextBean++;
        }
        StringWriter sw = new StringWriter();
        XMLStreamWriter xew = xmlOutputFactory.createXMLStreamWriter(sw);
        MCUtil.addXML(object, id, xew, sc);
        xew.flush();
        if (id == null) {
            id = "bean" + sc.nextBean++;
        }
        sc.beans.put(id, sw.toString());
        sc.ids.put(object, id);
        return id;
    }

    public static String toXML(Object object) {
        try {
            SerializationContext sc = new SerializationContext();
            MCUtil.defineBean(sc, object, "main", true);
            return sc.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class SerializationContext {
        boolean incomplete;
        HashMap<String, String> beans = new HashMap();
        HashMap<Object, String> ids = new HashMap();
        int nextBean = 1;

        private SerializationContext() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<spring:beans xmlns=\"http://membrane-soa.org/proxies/1/\"\r\n");
            sb.append("  xmlns:spring=\"http://www.springframework.org/schema/beans\"\r\n");
            sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
            sb.append("  xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-4.2.xsd\r\n");
            sb.append("    http://membrane-soa.org/proxies/1/ http://membrane-soa.org/schemas/proxies-1.xsd\">\r\n");
            sb.append("\r\n");
            if (this.incomplete) {
                sb.append("<!-- WARNING: This is an incomplete serialization of Membrane's configuration. Only use this config as a template for further processing. -->\r\n");
            }
            for (String def : this.beans.values()) {
                sb.append(def);
                sb.append("\r\n");
            }
            sb.append("\r\n");
            sb.append("</spring:beans>\r\n");
            return sb.toString();
        }
    }

    private static final class FileSystemXmlApplicationContextExtension
    extends FileSystemXmlApplicationContext {
        private final String MAGIC;
        private final String xml;

        private FileSystemXmlApplicationContextExtension(String MAGIC, String xml) {
            this.MAGIC = MAGIC;
            this.xml = xml;
        }

        public Resource getResource(String location) {
            if (this.MAGIC.equals(location)) {
                return new FileSystemResource(this.MAGIC){

                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8")));
                    }
                };
            }
            return super.getResource(location);
        }
    }
}

