/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot.generator;

import com.predic8.membrane.annot.AnnotUtils;
import com.predic8.membrane.annot.model.AttributeInfo;
import com.predic8.membrane.annot.model.ChildElementDeclarationInfo;
import com.predic8.membrane.annot.model.ChildElementInfo;
import com.predic8.membrane.annot.model.ElementInfo;
import com.predic8.membrane.annot.model.MainInfo;
import com.predic8.membrane.annot.model.Model;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public class BlueprintParsers {
    private final ProcessingEnvironment processingEnv;

    public BlueprintParsers(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeParserDefinitior(Model m) throws IOException {
        for (MainInfo main : m.getMains()) {
            ArrayList<Element> sources = new ArrayList<Element>();
            sources.addAll(main.getInterceptorElements());
            sources.add(main.getElement());
            try {
                JavaFileObject o = this.processingEnv.getFiler().createSourceFile(main.getAnnotation().outputPackage() + ".blueprint" + ".BlueprintNamespaceParser", sources.toArray(new Element[0]));
                try (BufferedWriter bw = new BufferedWriter(o.openWriter());){
                    bw.write("/* Copyright 2014 predic8 GmbH, www.predic8.com\r\n\r\n   Licensed under the Apache License, Version 2.0 (the \"License\");\r\n   you may not use this file except in compliance with the License.\r\n   You may obtain a copy of the License at\r\n\r\n   http://www.apache.org/licenses/LICENSE-2.0\r\n\r\n   Unless required by applicable law or agreed to in writing, software\r\n   distributed under the License is distributed on an \"AS IS\" BASIS,\r\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n   See the License for the specific language governing permissions and\r\n   limitations under the License. */\r\n\r\npackage " + main.getAnnotation().outputPackage() + ".blueprint;\r\n" + "\r\n" + "/**\r\n" + "  * Automatically generated by " + BlueprintParsers.class.getName() + ".\r\n" + "  */\r\n" + "public class BlueprintNamespaceParser extends com.predic8.membrane.annot.parser.BlueprintNamespaceParser {\r\n" + "\r\n" + "\tpublic void init() {\r\n");
                    for (ElementInfo i : main.getIis()) {
                        if (i.getAnnotation().topLevel()) {
                            bw.write("\t\tregisterGlobalBeanDefinitionParser(\"" + i.getAnnotation().name() + "\", new " + i.getParserClassSimpleName() + "());\r\n");
                            continue;
                        }
                        for (ChildElementDeclarationInfo cedi : i.getUsedBy()) {
                            for (ChildElementInfo cei : cedi.getUsedBy()) {
                                TypeElement element = cei.getEi().getElement();
                                String clazz = AnnotUtils.getRuntimeClassName(element);
                                bw.write("\t\tregisterLocalBeanDefinitionParser(\"" + clazz + "\", \"" + i.getAnnotation().name() + "\", new " + i.getParserClassSimpleName() + "());\r\n");
                            }
                        }
                    }
                    bw.write("\t}\r\n}\r\n");
                }
            }
            catch (FilerException e) {
                if (e.getMessage().contains("Source file already created")) {
                    return;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeParsers(Model m) throws IOException {
        for (MainInfo main : m.getMains()) {
            for (ElementInfo ii : main.getIis()) {
                ArrayList<TypeElement> sources = new ArrayList<TypeElement>();
                sources.add(main.getElement());
                sources.add(ii.getElement());
                String interceptorClassName = ii.getElement().getQualifiedName().toString();
                try {
                    JavaFileObject o = this.processingEnv.getFiler().createSourceFile(main.getAnnotation().outputPackage() + ".blueprint" + "." + ii.getParserClassSimpleName(), sources.toArray(new Element[0]));
                    try (BufferedWriter bw = new BufferedWriter(o.openWriter());){
                        bw.write("/* Copyright 2014 predic8 GmbH, www.predic8.com\r\n\r\n   Licensed under the Apache License, Version 2.0 (the \"License\");\r\n   you may not use this file except in compliance with the License.\r\n   You may obtain a copy of the License at\r\n\r\n   http://www.apache.org/licenses/LICENSE-2.0\r\n\r\n   Unless required by applicable law or agreed to in writing, software\r\n   distributed under the License is distributed on an \"AS IS\" BASIS,\r\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n   See the License for the specific language governing permissions and\r\n   limitations under the License. */\r\n\r\npackage " + main.getAnnotation().outputPackage() + ".blueprint;\r\n" + "\r\n" + "import com.predic8.membrane.annot.parser.BlueprintElementParser;\r\n" + "import com.predic8.membrane.annot.parser.BlueprintParser;\r\n" + "import org.apache.aries.blueprint.ParserContext;\r\n" + "import org.osgi.service.blueprint.reflect.Metadata;\r\n" + "import org.apache.aries.blueprint.mutable.MutableBeanMetadata;\r\n" + "import org.osgi.service.blueprint.reflect.BeanMetadata;\r\n" + "import org.w3c.dom.Element;\r\n" + "");
                        bw.write("\r\n/**\r\n  * Automatically generated by " + BlueprintParsers.class.getName() + ".\r\n" + "  */\r\n" + "public class " + ii.getParserClassSimpleName() + " extends BlueprintElementParser {\r\n" + "\tpublic Metadata parse(BlueprintParser globalParser, Element element, ParserContext context) {\r\n" + "\t\tMutableBeanMetadata mcm = context.createMetadata(MutableBeanMetadata.class);\r\n" + "\t\tmcm.setId(context.generateId());\r\n" + "\t\tmcm.setScope(BeanMetadata.SCOPE_SINGLETON);\r\n" + "\t\tmcm.setRuntimeClass(" + interceptorClassName + ".class);\r\n" + "\t\tapplySpringInterfacePatches(context, " + interceptorClassName + ".class, mcm);\r\n" + "\r\n");
                        if (ii.isHasIdField()) {
                            bw.write("\t\tsetPropertyIfSet(context, \"id\", element, mcm);\r\n");
                        }
                        bw.write("\t\tsetIdIfNeeded(element, context, \"" + ii.getAnnotation().name() + "\");\r\n");
                        for (AttributeInfo ai : ii.getAis()) {
                            if (ai.getXMLName().equals("id")) continue;
                            if (ai.isBeanReference(this.processingEnv.getTypeUtils())) {
                                if (!ai.isRequired()) {
                                    bw.write("\t\tif (element.hasAttribute(\"" + ai.getXMLName() + "\"))\r\n");
                                }
                                bw.write("\t\tsetPropertyReference(context, \"" + ai.getSpringName() + "\", element.getAttribute(\"" + ai.getXMLName() + "\"), mcm);\r\n");
                            } else {
                                bw.write("\t\tsetProperty" + (ai.isRequired() ? "" : "IfSet") + "(context, \"" + ai.getXMLName() + "\", \"" + ai.getSpringName() + "\", element, mcm" + (ai.isEnum(this.processingEnv.getTypeUtils()) ? ", true" : "") + ");\r\n");
                            }
                            if (!ai.getXMLName().equals("name")) continue;
                            bw.write("\t\telement.removeAttribute(\"name\");\r\n");
                        }
                        if (ii.getOai() != null) {
                            bw.write("\t\tsetProperties(context, \"" + ii.getOai().getSpringName() + "\", element, mcm);\r\n");
                        }
                        if (ii.getTci() != null) {
                            bw.write("\t\tsetProperty(context, mcm, \"" + ii.getTci().getPropertyName() + "\", element.getTextContent());\r\n");
                        } else {
                            bw.write("\t\tparseChildren(element, context, mcm, globalParser);\r\n");
                        }
                        for (ChildElementInfo cei : ii.getCeis()) {
                            if (!cei.isList() || !cei.isRequired()) continue;
                            bw.write("\t\tif (!isPropertySet(mcm, \"" + cei.getPropertyName() + "\"))\r\n");
                            bw.write("\t\t\tthrow new RuntimeException(\"Property '" + cei.getPropertyName() + "' is required, but none was defined (empty list).\");\r\n");
                        }
                        bw.write("\t\treturn mcm;\r\n");
                        bw.write("\t}\r\n");
                        bw.write("\t@Override\r\n\tprotected void handleChildObject(Element ele, ParserContext context, MutableBeanMetadata mcm, Class<?> clazz, Object child) {\r\n");
                        for (ChildElementInfo cei : ii.getCeis()) {
                            bw.write("\t\tif (" + cei.getTypeDeclaration().getQualifiedName() + ".class.isAssignableFrom(clazz)) {\r\n");
                            if (cei.isList()) {
                                bw.write("\t\t\tappendToListProperty(context, mcm, \"" + cei.getPropertyName() + "\"" + ", child);\r\n");
                            } else {
                                bw.write("\t\t\tsetProperty(context, mcm, \"" + cei.getPropertyName() + "\"" + ", child);\r\n");
                            }
                            bw.write("\t\t} else \r\n");
                        }
                        bw.write("\t\t{\r\n\t\t\tthrow new RuntimeException(\"Unknown child class \\\"\" + clazz + \"\\\".\");\r\n\t\t}\r\n");
                        bw.write("\t}\r\n");
                        bw.write("}\r\n");
                    }
                }
                catch (FilerException e) {
                    if (e.getMessage().contains("Source file already created")) {
                        return;
                    }
                    throw e;
                }
            }
        }
    }
}

