/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot.generator;

import com.predic8.membrane.annot.model.AbstractJavadocedInfo;
import com.predic8.membrane.annot.model.AttributeInfo;
import com.predic8.membrane.annot.model.ChildElementDeclarationInfo;
import com.predic8.membrane.annot.model.ChildElementInfo;
import com.predic8.membrane.annot.model.ElementInfo;
import com.predic8.membrane.annot.model.MainInfo;
import com.predic8.membrane.annot.model.Model;
import com.predic8.membrane.annot.model.OtherAttributesInfo;
import com.predic8.membrane.annot.model.doc.Doc;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class HelpReference {
    private final ProcessingEnvironment processingEnv;
    private XMLStreamWriter xew;
    private StringWriter sw;

    public HelpReference(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public void writeHelp(Model m) {
        try {
            String path = System.getenv("MEMBRANE_GENERATE_DOC_DIR");
            if (path == null) {
                return;
            }
            path = path.replace("%VERSION%", "4.2");
            this.sw = new StringWriter();
            XMLOutputFactory output = XMLOutputFactory.newInstance();
            this.xew = output.createXMLStreamWriter(this.sw);
            this.xew.writeStartDocument();
            this.handle(m);
            this.xew.writeEndDocument();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new StreamSource(new StringReader(this.sw.toString())), new StreamResult(new File(path + "/" + this.getFileName(m) + ".xml")));
            this.xew = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFileName(Model m) {
        ArrayList<String> packages = new ArrayList<String>();
        for (MainInfo mi : m.getMains()) {
            packages.add(mi.getAnnotation().outputPackage());
        }
        Collections.sort(packages);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packages.size(); ++i) {
            if (i > 0) {
                sb.append("-");
            }
            sb.append((String)packages.get(i));
        }
        return sb.toString();
    }

    private void handle(Model m) throws XMLStreamException {
        this.xew.writeStartElement("namespaces");
        for (MainInfo main : m.getMains()) {
            this.handle(m, main);
        }
        this.xew.writeEndElement();
    }

    private void handle(Model m, MainInfo main) throws XMLStreamException {
        this.xew.writeStartElement("namespace");
        this.xew.writeAttribute("package", main.getAnnotation().outputPackage());
        this.xew.writeAttribute("targetNamespace", main.getAnnotation().targetNamespace());
        Collections.sort(main.getIis(), new Comparator<ElementInfo>(){

            @Override
            public int compare(ElementInfo o1, ElementInfo o2) {
                int res = o1.getAnnotation().name().compareTo(o2.getAnnotation().name());
                if (res == 0) {
                    res = o1.getElement().getQualifiedName().toString().compareTo(o2.getElement().getQualifiedName().toString());
                }
                return res;
            }
        });
        for (ElementInfo ei : main.getIis()) {
            this.handle(m, main, ei);
        }
        this.xew.writeEndElement();
    }

    private void handle(Model m, MainInfo main, ElementInfo ei) throws XMLStreamException {
        List<ChildElementInfo> ceis;
        String primaryParentId;
        this.xew.writeStartElement("element");
        this.xew.writeAttribute("name", ei.getAnnotation().name());
        if (ei.getAnnotation().mixed()) {
            this.xew.writeAttribute("mixed", "true");
        }
        this.xew.writeAttribute("topLevel", Boolean.toString(ei.getAnnotation().topLevel()));
        this.xew.writeAttribute("id", ei.getId());
        if (!ei.getAnnotation().topLevel() && (primaryParentId = this.getPrimaryParentId(m, main, ei)) != null) {
            this.xew.writeAttribute("primaryParentId", primaryParentId);
        }
        this.handleDoc(ei);
        List<AttributeInfo> ais = ei.getAis();
        Collections.sort(ais, new Comparator<AttributeInfo>(){

            @Override
            public int compare(AttributeInfo o1, AttributeInfo o2) {
                return o1.getXMLName().compareTo(o2.getXMLName());
            }
        });
        OtherAttributesInfo oai = ei.getOai();
        if (ais.size() > 0 && ais.get(0).getXMLName().equals("id")) {
            ais.remove(0);
        }
        if (ais.size() > 0 || oai != null) {
            this.xew.writeStartElement("attributes");
            for (AttributeInfo ai : ais) {
                this.handle(ai);
            }
            if (oai != null) {
                this.xew.writeStartElement("any");
                this.handleDoc(oai);
                this.xew.writeEndElement();
            }
            this.xew.writeEndElement();
        }
        if ((ceis = ei.getCeis()).size() > 0) {
            this.xew.writeStartElement("children");
            for (ChildElementInfo cei : ceis) {
                this.handle(m, main, cei);
            }
            this.xew.writeEndElement();
        }
        this.xew.writeEndElement();
    }

    private String getPrimaryParentId(Model m, MainInfo mi, ElementInfo ei) {
        HashSet<ElementInfo> possibleParents = new HashSet<ElementInfo>();
        for (Map.Entry<TypeElement, ChildElementDeclarationInfo> e : mi.getChildElementDeclarations().entrySet()) {
            if (!e.getValue().getElementInfo().contains(ei)) continue;
            for (ChildElementInfo usedBy : e.getValue().getUsedBy()) {
                ElementInfo e2 = mi.getElements().get(usedBy.getEi().getElement());
                if (e2 == null) continue;
                possibleParents.add(e2);
            }
        }
        for (ElementInfo ei2 : possibleParents) {
            if (!ei2.getAnnotation().topLevel()) continue;
            return ei2.getId();
        }
        possibleParents.remove(ei);
        if (possibleParents.size() > 0) {
            return ((ElementInfo)possibleParents.iterator().next()).getId();
        }
        return null;
    }

    private void handle(Model m, MainInfo main, ChildElementInfo cei) throws XMLStreamException {
        this.xew.writeStartElement("child");
        this.xew.writeAttribute("min", cei.isRequired() ? "1" : "0");
        this.xew.writeAttribute("max", cei.isList() ? "unbounded" : "1");
        this.handleDoc(cei);
        TreeSet<String> possibilities = new TreeSet<String>();
        for (ElementInfo ei : main.getChildElementDeclarations().get(cei.getTypeDeclaration()).getElementInfo()) {
            possibilities.add(ei.getId());
        }
        for (String id : possibilities) {
            this.xew.writeStartElement("possibility");
            this.xew.writeAttribute("refId", id);
            this.xew.writeEndElement();
        }
        if (cei.getAnnotation().allowForeign()) {
            this.xew.writeStartElement("possibility");
            this.xew.writeAttribute("foreign", "true");
            this.xew.writeEndElement();
        }
        this.xew.writeEndElement();
    }

    private void handle(AttributeInfo ai) throws XMLStreamException {
        if (ai.getXMLName().equals("id")) {
            return;
        }
        this.xew.writeStartElement("attribute");
        this.xew.writeAttribute("name", ai.getXMLName());
        this.xew.writeAttribute("required", Boolean.toString(ai.isRequired()));
        this.handleDoc(ai);
        this.xew.writeEndElement();
    }

    private void handleDoc(AbstractJavadocedInfo info) throws XMLStreamException {
        Doc doc = info.getDoc(this.processingEnv);
        if (doc == null) {
            return;
        }
        this.xew.writeStartElement("documentation");
        for (Doc.Entry e : doc.getEntries()) {
            this.handleDoc(e);
        }
        this.xew.writeEndElement();
    }

    private void handleDoc(Doc.Entry e) throws XMLStreamException {
        this.xew.writeCharacters("");
        this.xew.flush();
        this.sw.append(e.getValueAsXMLSnippet(true));
    }
}

