/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot.model;

import com.predic8.membrane.annot.AnnotUtils;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.ProcessingException;
import com.predic8.membrane.annot.model.AbstractJavadocedInfo;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;

public class AttributeInfo
extends AbstractJavadocedInfo {
    private MCAttribute annotation;
    private ExecutableElement e;
    private boolean required;
    private String xsdType;
    private boolean isEnum;
    private boolean isBeanReference;

    public String getXMLName() {
        if (this.getAnnotation().attributeName().length() == 0) {
            return this.getSpringName();
        }
        return this.getAnnotation().attributeName();
    }

    public String getSpringName() {
        String s = this.getE().getSimpleName().toString();
        if (!s.substring(0, 3).equals("set")) {
            throw new ProcessingException("Setter method name is supposed to start with 'set'.", this.getE());
        }
        s = s.substring(3);
        return AnnotUtils.dejavaify(s);
    }

    public String getXSDType(Types typeUtils) {
        this.analyze(typeUtils);
        return this.xsdType;
    }

    public boolean isEnum(Types typeUtils) {
        this.analyze(typeUtils);
        return this.isEnum;
    }

    public boolean isBeanReference(Types typeUtils) {
        this.analyze(typeUtils);
        return this.isBeanReference;
    }

    private void analyze(Types typeUtils) {
        if (this.xsdType != null) {
            return;
        }
        if (this.getE().getParameters().size() != 1) {
            throw new ProcessingException("Setter is supposed to have 1 parameter.", this.getE());
        }
        VariableElement ve = this.getE().getParameters().get(0);
        switch (ve.asType().getKind()) {
            case INT: {
                this.xsdType = "spel_number";
                return;
            }
            case LONG: {
                this.xsdType = "spel_number";
                return;
            }
            case BOOLEAN: {
                this.xsdType = "spel_boolean";
                return;
            }
            case DECLARED: {
                TypeElement superClass;
                TypeElement e = (TypeElement)typeUtils.asElement(ve.asType());
                if (e.getQualifiedName().toString().equals("java.lang.String")) {
                    this.xsdType = "xsd:string";
                    return;
                }
                if (e.getSuperclass().getKind() == TypeKind.DECLARED && (superClass = (TypeElement)typeUtils.asElement(e.getSuperclass())).getQualifiedName().toString().equals("java.lang.Enum")) {
                    this.isEnum = true;
                    this.xsdType = "xsd:string";
                    return;
                }
                this.isBeanReference = true;
                this.xsdType = "xsd:string";
                return;
            }
        }
        throw new ProcessingException("Not implemented: XSD type for " + ve.asType().getKind().toString(), this.getE());
    }

    public MCAttribute getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(MCAttribute annotation) {
        this.annotation = annotation;
    }

    public ExecutableElement getE() {
        return this.e;
    }

    public void setE(ExecutableElement e) {
        this.e = e;
        this.setDocedE(e);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}

