/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot.model.doc;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;

public class Doc {
    static final XMLInputFactory fac = XMLInputFactory.newFactory();
    final ProcessingEnvironment processingEnv;
    final Element e;
    HashSet<String> keys = new HashSet();
    List<Entry> entries = new ArrayList<Entry>();
    static final List<String> POSITIVE = Arrays.asList("topic", "description", "example", "default", "explanation");
    static final List<String> NEGATIVE = Arrays.asList("author", "param");

    private void handle(String key, String value) {
        if ((value = value.trim()).length() == 0) {
            return;
        }
        if (NEGATIVE.contains(key)) {
            return;
        }
        if (!POSITIVE.contains(key)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unknown javadoc tag: " + key, this.e);
            return;
        }
        if (this.keys.contains(key)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Duplicate JavaDoc tag: " + key, this.e);
            return;
        }
        this.keys.add(key);
        this.entries.add(new Entry(key, value));
    }

    public Doc(ProcessingEnvironment processingEnv, String javadoc, Element e) {
        this.processingEnv = processingEnv;
        this.e = e;
        Matcher m = Pattern.compile("(?:^|[^{])@(\\w+)").matcher(javadoc);
        int last = -1;
        String key = null;
        while (m.find()) {
            if (last != -1) {
                this.handle(key, javadoc.substring(last + 1, m.start(1) - 1));
            }
            key = m.group(1);
            last = m.end(1);
        }
        if (last != -1) {
            this.handle(key, javadoc.substring(last));
        }
        Collections.sort(this.entries);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public class Entry
    implements Comparable<Entry> {
        String key;
        String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
            try {
                XMLEventReader xer = fac.createXMLEventReader(new StringReader(this.wrapInRootElement(value)));
                while (xer.hasNext()) {
                    XMLEvent event = xer.nextEvent();
                    if (!event.isEntityReference()) continue;
                    EntityReference er = (EntityReference)event;
                    Doc.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Entity " + er.getName() + " found, but not allowed.", Doc.this.e);
                }
            }
            catch (XMLStreamException f) {
                value = "";
                Doc.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, f.getMessage(), Doc.this.e);
            }
        }

        private String wrapInRootElement(String value) {
            return "<" + this.key + ">" + value + "</" + this.key + ">";
        }

        public String getKey() {
            return this.key;
        }

        public String getValueAsXMLSnippet(boolean wrap) {
            if (wrap) {
                return this.wrapInRootElement(this.value);
            }
            return this.value;
        }

        @Override
        public int compareTo(Entry o) {
            return POSITIVE.indexOf(this.key) - POSITIVE.indexOf(o.key);
        }
    }
}

