/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.annot.parser;

import com.predic8.membrane.annot.parser.BlueprintParser;
import com.predic8.membrane.annot.parser.BlueprintSpringInterfaceHelper;
import java.util.HashMap;
import java.util.Set;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BlueprintElementParser
implements BlueprintParser {
    private boolean inlined;

    public boolean isInlined() {
        return this.inlined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metadata parseChild(BlueprintParser globalParser, Element element, ParserContext context) {
        boolean oldInlined = this.inlined;
        this.inlined = true;
        try {
            Metadata metadata = this.parse(globalParser, element, context);
            return metadata;
        }
        finally {
            this.inlined = oldInlined;
        }
    }

    protected void applySpringInterfacePatches(ParserContext context, Class<?> clazz, MutableBeanMetadata mcm) {
        if (ApplicationContextAware.class.isAssignableFrom(clazz)) {
            MutableRefMetadata mirm = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
            mirm.setComponentId("blueprintContainer");
            MutableBeanMetadata helper = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
            helper.setId(context.generateId());
            helper.setScope("singleton");
            helper.setRuntimeClass(BlueprintSpringInterfaceHelper.class);
            helper.addProperty("blueprintContainer", (Metadata)mirm);
            context.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)helper);
            helper.addProperty("client", (Metadata)mcm);
            helper.setInitMethod("init");
            helper.setDestroyMethod("destroy");
            mcm.addDependsOn(helper.getId());
            return;
        }
        if (Lifecycle.class.isAssignableFrom(clazz)) {
            mcm.setInitMethod("start");
            mcm.setDestroyMethod("stop");
        }
    }

    protected void parseChildren(Element element, ParserContext context, MutableBeanMetadata mcm, BlueprintParser globalParser) {
        element.setUserData("parentClass", mcm.getRuntimeClass().getName(), null);
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            this.handleChildElement((Element)node, context, mcm, globalParser);
        }
    }

    protected void setIdIfNeeded(Element element, ParserContext context, String defaultId) {
        if (!this.isInlined() && !element.hasAttribute("id")) {
            Set names = context.getComponentDefinitionRegistry().getComponentDefinitionNames();
            int i = 0;
            while (true) {
                String id;
                if (!names.contains(id = defaultId + (i == 0 ? "" : Integer.valueOf(i)))) {
                    element.setAttribute("id", id);
                    return;
                }
                ++i;
            }
        }
    }

    protected abstract void handleChildObject(Element var1, ParserContext var2, MutableBeanMetadata var3, Class<?> var4, Object var5);

    protected void handleChildElement(Element ele, ParserContext context, MutableBeanMetadata mcm, BlueprintParser globalParser) {
        Metadata m = globalParser.parse(globalParser, ele, context);
        Class clazz = null;
        if (!(m instanceof MutableBeanMetadata)) {
            throw new RuntimeException("Don't know how to get bean class from " + m.getClass() + ": " + ele.getNodeName());
        }
        clazz = ((MutableBeanMetadata)m).getRuntimeClass();
        this.handleChildObject(ele, context, mcm, clazz, m);
    }

    protected void setPropertyIfSet(ParserContext context, String xmlPropertyName, String springPropertyName, Element element, MutableBeanMetadata mcm) {
        this.setPropertyIfSet(context, xmlPropertyName, springPropertyName, element, mcm, false);
    }

    private BeanProperty findProperty(MutableBeanMetadata mcm, String springPropertyName) {
        for (BeanProperty p : mcm.getProperties()) {
            if (!p.getName().equals(springPropertyName)) continue;
            return p;
        }
        return null;
    }

    protected boolean isPropertySet(MutableBeanMetadata mcm, String springPropertyName) {
        return this.findProperty(mcm, springPropertyName) != null;
    }

    protected void setProperty(ParserContext context, String xmlPropertyName, String springPropertyName, Element element, MutableBeanMetadata mcm) {
        this.setProperty(context, xmlPropertyName, springPropertyName, element, mcm, false);
    }

    protected void setPropertyIfSet(ParserContext context, String prop, Element element, MutableBeanMetadata mcm) {
        this.setPropertyIfSet(context, prop, prop, element, mcm);
    }

    protected void appendToListProperty(ParserContext context, MutableBeanMetadata mcm, String springPropertyName, Object child) {
        MutableCollectionMetadata proxies = null;
        BeanProperty bp = this.findProperty(mcm, springPropertyName);
        if (bp == null) {
            proxies = (MutableCollectionMetadata)context.createMetadata(MutableCollectionMetadata.class);
            mcm.addProperty(springPropertyName, (Metadata)proxies);
        } else {
            proxies = (MutableCollectionMetadata)bp.getValue();
        }
        proxies.addValue((Metadata)child);
    }

    protected void setProperty(ParserContext context, String xmlPropertyName, String springPropertyName, Element element, MutableBeanMetadata mcm, boolean flexibleEnum) {
        String value = element.getAttribute(xmlPropertyName);
        if (flexibleEnum) {
            value = value.toUpperCase();
        }
        MutableValueMetadata vm = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
        vm.setStringValue(value);
        mcm.addProperty(springPropertyName, (Metadata)vm);
    }

    protected void setPropertyIfSet(ParserContext context, String xmlPropertyName, String springPropertyName, Element element, MutableBeanMetadata mcm, boolean flexibleEnum) {
        if (element.hasAttribute(xmlPropertyName)) {
            this.setProperty(context, xmlPropertyName, springPropertyName, element, mcm, flexibleEnum);
        }
    }

    protected void setProperties(ParserContext context, String springPropertyName, Element element, MutableBeanMetadata mcm) {
        NamedNodeMap attributes = element.getAttributes();
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr item = (Attr)attributes.item(i);
            if (item.getLocalName() == null) continue;
            attrs.put(item.getLocalName(), item.getValue());
        }
        MutablePassThroughMetadata pt = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
        pt.setObject(attrs);
        mcm.addProperty(springPropertyName, (Metadata)pt);
    }

    protected void setProperty(ParserContext context, MutableBeanMetadata mcm, String springPropertyName, Object value) {
        if (value instanceof BeanMetadata) {
            mcm.addProperty(springPropertyName, (Metadata)value);
        } else {
            MutablePassThroughMetadata vm = (MutablePassThroughMetadata)context.createMetadata(MutablePassThroughMetadata.class);
            vm.setObject(value);
            mcm.addProperty(springPropertyName, (Metadata)vm);
        }
    }

    protected void setPropertyReference(ParserContext context, String springPropertyName, String beanId, MutableBeanMetadata mcm) {
        throw new RuntimeException("not implemented");
    }
}

