// Metawidget
//
// This file is dual licensed under both the LGPL
// (http://www.gnu.org/licenses/lgpl-2.1.html) and the EPL
// (http://www.eclipse.org/org/documents/epl-v10.php). As a
// recipient of Metawidget, you may choose to receive it under either
// the LGPL or the EPL.
//
// Commercial licenses are also available. See http://metawidget.org
// for details.

package org.metawidget.statically.layout;

import java.util.Map;

import org.metawidget.layout.iface.Layout;
import org.metawidget.statically.StaticMetawidget;
import org.metawidget.statically.StaticWidget;
import org.metawidget.statically.StaticXmlStub;

/**
 * @author <a href="http://kennardconsulting.com">Richard Kennard</a>
 */

public class SimpleLayout
	implements Layout<StaticWidget, StaticWidget, StaticMetawidget> {

	//
	// Public methods
	//

	public void layoutWidget( StaticWidget widget, String elementName, Map<String, String> attributes, StaticWidget container, StaticMetawidget metawidget ) {

		// Ignore stubs

		if ( widget instanceof StaticXmlStub && widget.getChildren().isEmpty() ) {
			return;
		}

		container.getChildren().add( widget );
	}
}
