/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.widgetbuilder;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.metawidget.gwt.client.ui.GwtMetawidget;
import org.metawidget.gwt.client.ui.GwtUtils;
import org.metawidget.gwt.client.ui.GwtValueAccessor;
import org.metawidget.gwt.client.ui.Stub;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtWidgetBuilder
implements WidgetBuilder<Widget, GwtMetawidget>,
GwtValueAccessor {
    @Override
    public Object getValue(Widget widget) {
        if (widget instanceof CheckBox) {
            return ((CheckBox)widget).getValue();
        }
        if (widget instanceof HasText) {
            return ((HasText)widget).getText();
        }
        if (widget instanceof ListBox) {
            ListBox listBox = (ListBox)widget;
            return listBox.getValue(listBox.getSelectedIndex());
        }
        return null;
    }

    @Override
    public boolean setValue(Widget widget, Object value) {
        if (widget instanceof CheckBox) {
            ((CheckBox)widget).setValue((Boolean)value);
            return true;
        }
        if (widget instanceof HasText) {
            ((HasText)widget).setText(StringUtils.quietValueOf(value));
            return true;
        }
        if (widget instanceof ListBox) {
            GwtUtils.setListBoxSelectedItem((ListBox)widget, StringUtils.quietValueOf(value));
            return true;
        }
        return false;
    }

    @Override
    public Widget buildWidget(String elementName, Map<String, String> attributes, GwtMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new Stub();
        }
        if ("action".equals(elementName)) {
            return new Button(metawidget.getLabelString(attributes));
        }
        String type = GwtUtils.getActualClassOrType(attributes);
        if (type == null) {
            type = String.class.getName();
        }
        if ("Boolean".equals(type) && "true".equals(attributes.get("required"))) {
            return new CheckBox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            ListBox listBox = new ListBox();
            listBox.setVisibleItemCount(1);
            this.addListBoxItems(listBox, GwtUtils.fromString(lookup, ','), GwtUtils.fromString(attributes.get("lookup-labels"), ','), attributes);
            return listBox;
        }
        if (GwtUtils.isPrimitive(type)) {
            if ("boolean".equals(type)) {
                return new CheckBox();
            }
            if ("char".equals(type)) {
                TextBox textbox = new TextBox();
                textbox.setMaxLength(1);
                return textbox;
            }
            return new TextBox();
        }
        if (String.class.getName().equals(type)) {
            if ("true".equals(attributes.get("masked"))) {
                return new PasswordTextBox();
            }
            if ("true".equals(attributes.get("large"))) {
                return new TextArea();
            }
            TextBox textBox = new TextBox();
            String maximumLength = attributes.get("maximum-length");
            if (maximumLength != null && !"".equals(maximumLength)) {
                textBox.setMaxLength(Integer.parseInt(maximumLength));
            }
            return textBox;
        }
        if (Date.class.getName().equals(type)) {
            return new TextBox();
        }
        if (GwtUtils.isPrimitiveWrapper(type)) {
            if (Character.class.getName().equals(type)) {
                TextBox textbox = new TextBox();
                textbox.setMaxLength(1);
                return textbox;
            }
            return new TextBox();
        }
        if (GwtUtils.isCollection(type)) {
            return new Stub();
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return new TextBox();
        }
        return null;
    }

    private void addListBoxItems(ListBox listBox, List<String> values, List<String> labels, Map<String, String> attributes) {
        if (values == null) {
            return;
        }
        if (GwtUtils.needsEmptyLookupItem(attributes)) {
            this.addListBoxItem(listBox, "", null);
        }
        if (labels != null && !labels.isEmpty() && labels.size() != values.size()) {
            throw new RuntimeException("Labels list must be same size as values list");
        }
        int length = values.size();
        for (int loop = 0; loop < length; ++loop) {
            String value = values.get(loop);
            String label = null;
            if (labels != null && !labels.isEmpty()) {
                label = labels.get(loop);
            }
            this.addListBoxItem(listBox, value, label);
        }
    }

    private void addListBoxItem(ListBox listBox, String value, String label) {
        if (label != null) {
            listBox.addItem(label, value);
            return;
        }
        listBox.addItem(value);
    }
}

