/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.type;

import java.util.Map;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.type.TypeMappingInspectionResultProcessorConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappingInspectionResultProcessor<M>
extends BaseInspectionResultProcessor<M> {
    private Map<String, String> mTypeMappings = CollectionUtils.newHashMap();
    private boolean mRemoveUnmappedTypes;

    public TypeMappingInspectionResultProcessor(TypeMappingInspectionResultProcessorConfig config) {
        if (config.getTypeMappings() != null) {
            this.mTypeMappings.putAll(config.getTypeMappings());
        }
        this.mRemoveUnmappedTypes = config.isRemoveUnmappedTypes();
    }

    @Override
    protected void processAttributes(Map<String, String> attributes, M metawidget) {
        if (!attributes.containsKey("type")) {
            return;
        }
        String type = attributes.get("type");
        if (this.mTypeMappings.containsKey(type)) {
            attributes.put("type", this.mTypeMappings.get(type));
            return;
        }
        if (this.mRemoveUnmappedTypes) {
            attributes.put("type", null);
        }
    }
}

