/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Arrays;
import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecorator;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;
import org.metawidget.layout.decorator.NestedSectionLayoutDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlatSectionLayoutDecorator<W, C extends W, M extends C>
extends LayoutDecorator<W, C, M> {
    protected FlatSectionLayoutDecorator(LayoutDecoratorConfig<W, C, M> config) {
        super(config);
    }

    @Override
    public void startContainerLayout(C container, M metawidget) {
        super.startContainerLayout(container, metawidget);
        State state = this.getState(container, metawidget);
        state.setCurrentSections(null);
    }

    @Override
    public void layoutWidget(W widget, String elementName, Map<String, String> attributes, C container, M metawidget) {
        State state = this.getState(container, metawidget);
        if (this.getDelegate() instanceof NestedSectionLayoutDecorator) {
            String section = this.stripSection(attributes);
            if (this.isIgnored(widget) || section == null || state.getCurrentSections() != null && section.equals(state.getCurrentSections()[0])) {
                super.layoutWidget(widget, elementName, attributes, container, metawidget);
                return;
            }
            if (state.getCurrentSections() != null && !section.equals(state.getCurrentSections()[0])) {
                super.endContainerLayout(container, metawidget);
            }
            state.setCurrentSections(new String[]{section});
            if (!"".equals(section)) {
                this.addSectionWidget(section, 0, container, metawidget);
            }
        } else {
            Object[] sections = this.getSections(attributes);
            if (this.isIgnored(widget) || sections.length == 0 || Arrays.equals(sections, state.getCurrentSections())) {
                super.layoutWidget(widget, elementName, attributes, container, metawidget);
                return;
            }
            for (int level = 0; level < sections.length; ++level) {
                Object section = sections[level];
                if ("".equals(section) || state.getCurrentSections() != null && level < state.getCurrentSections().length && ((String)section).equals(state.getCurrentSections()[level])) continue;
                this.addSectionWidget((String)section, level, container, metawidget);
            }
            state.setCurrentSections((String[])sections);
        }
        super.layoutWidget(widget, elementName, attributes, container, metawidget);
    }

    protected abstract String stripSection(Map<String, String> var1);

    protected abstract String[] getSections(Map<String, String> var1);

    protected abstract State getState(C var1, M var2);

    protected abstract boolean isIgnored(W var1);

    protected abstract void addSectionWidget(String var1, int var2, C var3, M var4);

    public static class State {
        private String[] mCurrentSections;

        public String[] getCurrentSections() {
            return this.mCurrentSections;
        }

        public void setCurrentSections(String[] currentSections) {
            if (currentSections == null) {
                this.mCurrentSections = null;
            } else {
                this.mCurrentSections = new String[currentSections.length];
                System.arraycopy(currentSections, 0, this.mCurrentSections, 0, currentSections.length);
            }
        }
    }
}

