/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.layout.GridBagLayoutConfig;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBagLayout
implements AdvancedLayout<JComponent, JComponent, SwingMetawidget> {
    private static final int SMALL_GAP = 3;
    private static final Insets INSETS_COMPONENT = new Insets(0, 0, 3, 0);
    private static final String LABEL_NAME_SUFFIX = "_label";
    private final int mNumberOfColumns;
    private final int mLabelAlignment;
    private final Font mLabelFont;
    private final Color mLabelForeground;
    private final boolean mSupportMnemonics;
    private final String mLabelSuffix;
    private final int mRequiredAlignment;
    private final String mRequiredText;

    public GridBagLayout() {
        this(new GridBagLayoutConfig());
    }

    public GridBagLayout(GridBagLayoutConfig config) {
        this.mNumberOfColumns = config.getNumberOfColumns();
        this.mLabelAlignment = config.getLabelAlignment();
        this.mLabelForeground = config.getLabelForeground();
        this.mLabelFont = config.getLabelFont();
        this.mSupportMnemonics = config.isSupportMnemonics();
        this.mLabelSuffix = config.getLabelSuffix();
        this.mRequiredAlignment = config.getRequiredAlignment();
        this.mRequiredText = config.getRequiredText();
    }

    @Override
    public void onStartBuild(SwingMetawidget metawidget) {
    }

    @Override
    public void startContainerLayout(JComponent container, SwingMetawidget metawidget) {
        container.putClientProperty(GridBagLayout.class, null);
        State state = this.getState(container);
        java.awt.GridBagLayout layoutManager = new java.awt.GridBagLayout();
        container.setLayout(layoutManager);
        JTextField dummyTextField = new JTextField();
        dummyTextField.setLayout(layoutManager);
        double dummyTextFieldHeight = dummyTextField.getPreferredSize().getHeight();
        JLabel dummyLabel = new JLabel("X");
        dummyLabel.setLayout(layoutManager);
        double dummyLabelHeight = dummyLabel.getPreferredSize().getHeight();
        int defaultLabelVerticalPadding = (int)Math.max(0.0, Math.floor((dummyTextFieldHeight - dummyLabelHeight) / 2.0));
        state.defaultLabelInsetsFirstColumn = new Insets(defaultLabelVerticalPadding, 0, defaultLabelVerticalPadding, 3);
        state.defaultLabelInsetsRemainderColumns = new Insets(defaultLabelVerticalPadding, 3, defaultLabelVerticalPadding, 3);
    }

    @Override
    public void layoutWidget(JComponent component, String elementName, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        if (component instanceof Stub && ((Stub)component).getComponentCount() == 0) {
            return;
        }
        State state = this.getState(container);
        boolean spanAllColumns = this.willFillHorizontally(component, attributes);
        if (spanAllColumns && state.currentColumn > 0) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
        String labelText = null;
        if (attributes != null) {
            labelText = metawidget.getLabelString(attributes);
        }
        this.layoutBeforeChild(component, labelText, elementName, attributes, container, metawidget);
        GridBagConstraints componentConstraints = new GridBagConstraints();
        this.setFillConstraints(component, componentConstraints);
        componentConstraints.anchor = 17;
        componentConstraints.gridx = state.currentColumn * (this.mRequiredAlignment == 4 ? 3 : 2);
        int numberOfColumns = this.getEffectiveNumberOfColumns(metawidget);
        if (labelText != null) {
            if (numberOfColumns == 0) {
                ++state.currentRow;
            } else {
                ++componentConstraints.gridx;
            }
        } else {
            componentConstraints.gridwidth = 2;
        }
        componentConstraints.gridy = state.currentRow;
        componentConstraints.weightx = 1.0f / (float)numberOfColumns;
        componentConstraints.insets = INSETS_COMPONENT;
        if (spanAllColumns) {
            componentConstraints.gridwidth = this.mRequiredAlignment == 4 ? numberOfColumns * 3 - componentConstraints.gridx - 1 : 0;
            state.currentColumn = numberOfColumns - 1;
        }
        if (this.willFillVertically(component, attributes)) {
            componentConstraints.weighty = 1.0;
            state.needSpacerRow = false;
        }
        container.add((Component)component, componentConstraints);
        this.layoutAfterChild(component, attributes, container, metawidget);
        ++state.currentColumn;
        if (state.currentColumn >= numberOfColumns) {
            state.currentColumn = 0;
            ++state.currentRow;
        }
    }

    @Override
    public void endContainerLayout(JComponent container, SwingMetawidget metawidget) {
        State state = this.getState(container);
        if (state.needSpacerRow && container.getComponentCount() > 0) {
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
                ++state.currentRow;
            }
            JPanel spacerPanel = new JPanel();
            spacerPanel.setOpaque(false);
            GridBagConstraints spacerConstraints = new GridBagConstraints();
            spacerConstraints.gridy = state.currentRow;
            spacerConstraints.weighty = 1.0;
            container.add((Component)spacerPanel, spacerConstraints);
            state.currentColumn = this.mNumberOfColumns;
        }
    }

    @Override
    public void onEndBuild(SwingMetawidget metawidget) {
        Facet buttonsFacet = metawidget.getFacet("buttons");
        if (buttonsFacet != null) {
            State state = this.getState(metawidget);
            if (state.currentColumn > 0) {
                state.currentColumn = 0;
                ++state.currentRow;
            }
            GridBagConstraints buttonConstraints = new GridBagConstraints();
            buttonConstraints.fill = 1;
            buttonConstraints.anchor = 17;
            buttonConstraints.gridy = state.currentRow;
            buttonConstraints.gridwidth = 0;
            metawidget.add((Component)buttonsFacet, buttonConstraints);
        }
    }

    protected void layoutBeforeChild(JComponent child, String labelText, String elementName, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        State state = this.getState(container);
        if (SimpleLayoutUtils.needsLabel(labelText, elementName)) {
            JLabel label = new JLabel();
            label.setName(attributes.get("name") + LABEL_NAME_SUFFIX);
            if (this.mLabelFont != null) {
                label.setFont(this.mLabelFont);
            }
            if (this.mLabelForeground != null) {
                label.setForeground(this.mLabelForeground);
            }
            label.setHorizontalAlignment(this.mLabelAlignment);
            SimpleLayoutUtils.StrippedMnemonicAndFirstIndex strippedMnemonicAndFirstIndex = SimpleLayoutUtils.stripMnemonic(labelText);
            String labelTextToUse = strippedMnemonicAndFirstIndex.getStrippedMnemonic();
            if (this.mRequiredText != null && "true".equals(attributes.get("required")) && !WidgetBuilderUtils.isReadOnly(attributes) && !metawidget.isReadOnly()) {
                if (this.mRequiredAlignment == 0) {
                    labelTextToUse = labelTextToUse + this.mRequiredText;
                } else if (this.mRequiredAlignment == 2) {
                    labelTextToUse = this.mRequiredText + labelTextToUse;
                }
            }
            if (this.mLabelSuffix != null) {
                labelTextToUse = labelTextToUse + this.mLabelSuffix;
            }
            label.setText(labelTextToUse);
            label.setLabelFor(child);
            int mnemonicIndex = strippedMnemonicAndFirstIndex.getFirstIndex();
            if (mnemonicIndex != -1 && this.mSupportMnemonics) {
                label.setDisplayedMnemonic(labelTextToUse.charAt(mnemonicIndex));
                label.setDisplayedMnemonicIndex(mnemonicIndex);
            }
            GridBagConstraints labelConstraints = new GridBagConstraints();
            labelConstraints.gridx = state.currentColumn * (this.mRequiredAlignment == 4 ? 3 : 2);
            labelConstraints.gridy = state.currentRow;
            labelConstraints.fill = 2;
            labelConstraints.weightx = 0.1f / (float)this.getEffectiveNumberOfColumns(metawidget);
            labelConstraints.anchor = 18;
            labelConstraints.insets = state.currentColumn == 0 ? state.defaultLabelInsetsFirstColumn : state.defaultLabelInsetsRemainderColumns;
            container.add((Component)label, labelConstraints);
        }
    }

    protected void layoutAfterChild(JComponent child, Map<String, String> attributes, JComponent container, SwingMetawidget metawidget) {
        State state = this.getState(container);
        if (this.mRequiredAlignment != 4) {
            return;
        }
        if (attributes == null || !"true".equals(attributes.get("required")) || WidgetBuilderUtils.isReadOnly(attributes) || metawidget.isReadOnly()) {
            return;
        }
        JLabel star = new JLabel();
        star.setText(this.mRequiredText);
        GridBagConstraints starConstraints = new GridBagConstraints();
        starConstraints.gridx = state.currentColumn * 3 + 2;
        starConstraints.gridy = state.currentRow;
        starConstraints.anchor = 18;
        starConstraints.insets = state.currentColumn == 0 ? state.defaultLabelInsetsFirstColumn : state.defaultLabelInsetsRemainderColumns;
        container.add((Component)star, starConstraints);
    }

    protected boolean willFillHorizontally(JComponent component, Map<String, String> attributes) {
        if (component instanceof JScrollPane) {
            return true;
        }
        if (component instanceof SwingMetawidget) {
            return true;
        }
        return SimpleLayoutUtils.isSpanAllColumns(attributes);
    }

    protected boolean willFillVertically(JComponent component, Map<String, String> attributes) {
        if (attributes != null && "true".equals(attributes.get("large"))) {
            return true;
        }
        return component instanceof JScrollPane;
    }

    protected void setFillConstraints(JComponent component, GridBagConstraints componentConstraints) {
        if (component instanceof JButton) {
            return;
        }
        componentConstraints.fill = 1;
    }

    private int getEffectiveNumberOfColumns(SwingMetawidget metawidget) {
        if (metawidget.getParent() instanceof SwingMetawidget) {
            return 1;
        }
        return this.mNumberOfColumns;
    }

    private State getState(JComponent container) {
        State state = (State)container.getClientProperty(GridBagLayout.class);
        if (state == null) {
            state = new State();
            container.putClientProperty(GridBagLayout.class, state);
        }
        return state;
    }

    static class State {
        int currentColumn;
        int currentRow;
        Insets defaultLabelInsetsFirstColumn;
        Insets defaultLabelInsetsRemainderColumns;
        boolean needSpacerRow = true;

        State() {
        }
    }
}

